/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.storage;

import com.Gabou.sereneseasonsplus.util.WorldContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class SnowSavedData
extends SavedData {
    private static volatile SnowSavedData INSTANCE;
    public int winterId = -1;
    public int stormCount = 0;
    public boolean stormActive = false;
    public final Set<Long> pendingChunks = new HashSet<Long>();
    public final Set<Long> observedChunks = new HashSet<Long>();
    public int lastBlanketStormCount = 0;

    public static SnowSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
        long[] observed;
        long[] pending;
        SnowSavedData data = new SnowSavedData();
        if (tag == null) {
            return data;
        }
        data.winterId = tag.getInt("WinterId");
        data.stormCount = tag.getInt("StormCount");
        data.stormActive = tag.getBoolean("StormActive");
        data.lastBlanketStormCount = tag.getInt("LastBlanketStormCount");
        for (long v : pending = tag.getLongArray("PendingChunks")) {
            data.pendingChunks.add(v);
        }
        for (long v : observed = tag.getLongArray("ObservedChunks")) {
            data.observedChunks.add(v);
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("WinterId", this.winterId);
        tag.putInt("StormCount", this.stormCount);
        tag.putBoolean("StormActive", this.stormActive);
        tag.putInt("LastBlanketStormCount", this.lastBlanketStormCount);
        long[] pending = new long[this.pendingChunks.size()];
        int i = 0;
        for (Long v : this.pendingChunks) {
            pending[i++] = v;
        }
        tag.putLongArray("PendingChunks", pending);
        long[] observed = new long[this.observedChunks.size()];
        i = 0;
        for (Long v : this.observedChunks) {
            observed[i++] = v;
        }
        tag.putLongArray("ObservedChunks", observed);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnowSavedData get() {
        SnowSavedData inst = INSTANCE;
        if (inst != null) {
            return inst;
        }
        Class<SnowSavedData> clazz = SnowSavedData.class;
        synchronized (SnowSavedData.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
            ServerLevel overworld = WorldContext.getOverworld();
            INSTANCE = overworld != null ? (SnowSavedData)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(SnowSavedData::new, SnowSavedData::load, DataFixTypes.LEVEL), "ssp_snow_data") : new SnowSavedData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void clearCachedInstance() {
        INSTANCE = null;
    }
}

