package xyz.lynxs.terrarium;


import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import xyz.lynxs.terrarium.preset.presetConfig;
import xyz.lynxs.terrarium.world.gen.TerrariumRegistries;
import xyz.lynxs.terrarium.world.gen.biome.TerrariumBiomeSource;
import xyz.lynxs.terrarium.world.gen.chunk.TerrariumChunkGenerator;

import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import java.nio.file.Path;

import static xyz.lynxs.terrarium.TerrariumConfig.load;
import static xyz.lynxs.terrarium.world.gen.HeightProvider.init;


public class Terrarium implements ModInitializer {
    public static final String MOD_ID = "terrarium";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static presetConfig CONFIG = new presetConfig();
    public  static TerrariumConfig CONFIG1 = ConfigManager.register(TerrariumConfig.class, Path.of("terrarium.json"), newConfig -> CONFIG1 = newConfig);
    public static class_2960 id(String path) {
        return class_2960.method_43902(MOD_ID, path);
    }

    // Server-side world load
    public static void onServerWorldLoad(MinecraftServer server, class_3218 world) {
        if (world.method_14178().method_12129().method_39301().get().method_29177().method_12836().contains("terrarium")) {

            CONFIG = load(CONFIG.getClass(), server.method_27050(class_5218.field_24188).resolve("terrarium.json"), false);
            init();
            LOGGER.info("Terrarium World Loaded!");
        }
    }


    @Override
    public void onInitialize() {
        LOGGER.info("Terrarium Loaded");
        // Register custom chunk generator
        class_2378.method_10230(
                class_7923.field_41156,
                id("biome_source"),
                TerrariumBiomeSource.CODEC
        );

        // Register chunk generator
        class_2378.method_10230(
                class_7923.field_41157,
                id("chunk_generator"),
                TerrariumChunkGenerator.CODEC
        );
        TerrariumRegistries.register();
        ServerWorldEvents.LOAD.register(Terrarium::onServerWorldLoad);

    }




}
