package xyz.lynxs.terrarium.gui;


import xyz.lynxs.terrarium.TerrariumConfig;
import xyz.lynxs.terrarium.preset.presetConfig;

import java.nio.file.Path;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;

import static xyz.lynxs.terrarium.Terrarium.CONFIG;
import static xyz.lynxs.terrarium.Terrarium.MOD_ID;
import static xyz.lynxs.terrarium.Util.gridToLatLon;
import static xyz.lynxs.terrarium.Util.truncate;

public class terrariumCustomizeScreen extends class_437 {
    private final class_525 parent;
    private  class_4185 doneButton, cancelButton;
    private Slider zoomSlider, worldHeightSlider, xOffsetSlider, zOffsetSlider, noiseScaleSlider, monthSlider;
    private double[] latlon;
    private final presetConfig config;


    public terrariumCustomizeScreen(class_525 parent) {
        super(class_5244.field_39003);
        this.parent = parent;
        config = new presetConfig();
        latlon = gridToLatLon(config.adjustXoffset, config.adjustZoffset,(int) (256 * Math.pow(2, config.zoom)));
    }

    @Override
    protected void method_25426() {
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonPadding = 5;



        bottomPanel(buttonWidth, buttonHeight, buttonPadding);
        Settings();
    }
    private void Settings(){
        int sliderPadding = 10;
        int sliderWidth = this.field_22789 - 2 * sliderPadding;
        int sliderHeight = 20;
        zoomSlider = new Slider(sliderPadding,this.field_22793.field_2000 + sliderPadding + sliderHeight, sliderWidth, sliderHeight, config.zoom, 0, 15, class_2561.method_43471(MOD_ID + ".text.slider.zoom"), Slider.Format.INT, (slider, value)-> {
            config.zoom = (int) slider.scaleValue(value);
            return value;
        });
        worldHeightSlider = new Slider(sliderPadding,this.field_22793.field_2000 + sliderPadding * 2 + sliderHeight * 2, sliderWidth, sliderHeight, config.worldHeight, 4, 4096, class_2561.method_43471(MOD_ID + ".text.slider.world_height"), Slider.Format.INT, (slider, value)-> {
            config.worldHeight = (int) slider.scaleValue(value);
            return value;
        });
        xOffsetSlider = new Slider(sliderPadding,this.field_22793.field_2000 + sliderPadding * 3 + sliderHeight * 3, sliderWidth, sliderHeight, config.adjustXoffset, 0, (int) (256 * Math.pow(2, config.zoom)), class_2561.method_43471(MOD_ID + ".text.slider.x_offset"), Slider.Format.INT, (slider, value)-> {
            config.adjustXoffset =  ((int) slider.scaleValue(value) - ((int) (slider.scaleValue(value) )% 16));
            latlon = gridToLatLon(config.adjustXoffset, config.adjustZoffset, (int) (256 * Math.pow(2, config.zoom)));
            return value;
        });
        zOffsetSlider = new Slider(sliderPadding,this.field_22793.field_2000 + sliderPadding * 4 + sliderHeight * 4, sliderWidth, sliderHeight, config.adjustZoffset, 0, (int) (256 * Math.pow(2, config.zoom)), class_2561.method_43471(MOD_ID + ".text.slider.z_offset"), Slider.Format.INT, (slider, value)-> {
            config.adjustZoffset = ((int) slider.scaleValue(value) - ((int)(slider.scaleValue(value)) % 16));
            latlon = gridToLatLon(config.adjustXoffset, config.adjustZoffset, (int) (256 * Math.pow(2, config.zoom)));
            return value;
        });
        noiseScaleSlider = new Slider(sliderPadding,this.field_22793.field_2000 + sliderPadding * 5 + sliderHeight * 5, sliderWidth, sliderHeight, (float) config.noise_biome_scale, 0.000001f, 1.0f, class_2561.method_43471(MOD_ID + ".text.slider.biome_noise"), Slider.Format.FLOAT, (slider, value)-> {
            config.noise_biome_scale = slider.scaleValue(value);
            return value;
        });
        monthSlider = new Slider(sliderPadding,this.field_22793.field_2000 + sliderPadding * 6 + sliderHeight * 6, sliderWidth, sliderHeight, config.month, 0, 11, class_2561.method_43471(MOD_ID + ".text.slider.month"), Slider.Format.INT, (slider, value)-> {
            config.month = (int) slider.scaleValue(value);
            return value;
        });

        this.method_37063(zoomSlider);
        this.method_37063(noiseScaleSlider);
        this.method_37063(worldHeightSlider);
        this.method_37063(xOffsetSlider);
        this.method_37063(zOffsetSlider);
        this.method_37063(monthSlider);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);

        // Minecraft doesn't have a "label" widget, so we'll have to draw our own text.
        // We'll subtract the font height from the Y position to make the text appear above the button.
        // Subtracting an extra 10 pixels will give the text some padding.
        // textRenderer, text, x, y, color, hasShadow
        context.method_51430(this.field_22793, class_2561.method_43471(MOD_ID + ".text.config_title").method_27692(class_124.field_1078).method_30937(), 10, this.field_22793.field_2000, 0xFFFFFFFF, true);
        context.method_51439(this.field_22793, class_2561.method_43469(MOD_ID + ".text.lat_lon", truncate(latlon[0],4), truncate(latlon[1], 4)), 100, this.field_22793.field_2000, 0xFFFFFFFF, true);
    }

    private void bottomPanel(int buttonWidth, int buttonHeight, int buttonPadding){
        assert this.field_22787 != null;

        doneButton = class_4185.method_46430(class_5244.field_24334, (btn) -> {
            CONFIG = config;
            TerrariumConfig.save(CONFIG, Path.of("./saves/" + parent.method_48657().method_49703() + "/terrarium.json"), false);
            this.field_22787.method_1507(parent);
        }).method_46434((this.field_22789 / 2) - (buttonWidth + buttonPadding), this.field_22790 - (buttonPadding + buttonHeight) , buttonWidth, buttonHeight).method_46431();
        cancelButton = class_4185.method_46430(class_5244.field_24335, (btn) -> {
            CONFIG = new presetConfig();
            this.field_22787.method_1507(parent);
        }).method_46434((this.field_22789/2) + buttonPadding, this.field_22790 - (buttonPadding + buttonHeight), buttonWidth, buttonHeight).method_46431();



        this.method_37063(doneButton);
        this.method_37063(cancelButton);
    }
}
