package xyz.lynxs.terrarium.mixin;

import xyz.lynxs.terrarium.accessor.TerrariumSurfaceBuilderAccessor;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_4543;
import net.minecraft.class_5539;
import net.minecraft.class_5868;
import net.minecraft.class_6557;
import net.minecraft.class_6568;
import net.minecraft.class_6686;
import net.minecraft.class_6724;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_6724.class)
public abstract class SurfaceBuilderMixin implements TerrariumSurfaceBuilderAccessor {
    @Shadow protected abstract void placeBadlandsPillar(class_6557 column, int x, int z, int surfaceY, class_5539 chunk);

    @Shadow protected abstract boolean isDefaultBlock(class_2680 state);

    @Shadow @Final private class_2680 defaultState;

    @Shadow protected abstract void placeIceberg(int minY, class_1959 biome, class_6557 column, class_2338.class_2339 mutablePos, int x, int z, int surfaceY);

    @Override
    public void buildSurface(class_7138 noiseConfig, class_4543 biomeAccess, class_2378<class_1959> biomeRegistry, boolean useLegacyRandom, class_5868 heightContext, final class_2791 chunk, class_6568 chunkNoiseSampler, class_6686.class_6708 materialRule) {
        final class_2338.class_2339 mutable = new class_2338.class_2339();
        final class_1923 chunkPos = chunk.method_12004();
        int i = chunkPos.method_8326();
        int j = chunkPos.method_8328();
        class_6557 blockColumn = new class_6557(){

            @Override
            public class_2680 method_32892(int y) {
                return chunk.method_8320(mutable.method_33098(y));
            }

            @Override
            public void method_38092(int y, class_2680 state) {
                class_5539 heightLimitView = chunk.method_39460();
                if (y >= heightLimitView.method_31607() && y < heightLimitView.method_31600()) {
                    chunk.method_12010(mutable.method_33098(y), state, false);
                    if (!state.method_26227().method_15769()) {
                        chunk.method_12039(mutable);
                    }
                }
            }

            public String toString() {
                return "ChunkBlockColumn " + chunkPos;
            }
        };
        class_6686.class_6694 materialRuleContext = MaterialRuleContextAccessor.createMaterialRuleContext((((class_6724) (Object) this)), noiseConfig, chunk, chunkNoiseSampler, biomeAccess::method_22393, biomeRegistry, heightContext);
        class_6686.class_6715 blockStateRule = materialRule.apply(materialRuleContext);
        class_2338.class_2339 mutable2 = new class_2338.class_2339();
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int m = i + k;
                int n = j + l;
                int o = chunk.method_12005(class_2902.class_2903.field_13194, k, l) + 1;
                mutable.method_33097(m).method_33099(n);
                class_6880<class_1959> registryEntry = biomeAccess.method_22393(mutable2.method_10103(m, useLegacyRandom ? 0 : o, n));
                if (registryEntry.method_40225(class_1972.field_9443)) {
                    this.placeBadlandsPillar(blockColumn, m, n, o, chunk);
                }
                int p = chunk.method_12005(class_2902.class_2903.field_13194, k, l) + 1;
                ((MaterialRuleContextAccessor)(Object)materialRuleContext).callInitHorizontalContext(m, n);
                int q = 0;
                int r = Integer.MIN_VALUE;
                int s = Integer.MAX_VALUE;
                int t = chunk.method_31607();
                for (int u = p; u >= t; --u) {
                    class_2680 blockState2;
                    int v;
                    class_2680 blockState = blockColumn.method_32892(u);
                    if (blockState.method_26215()) {
                        q = 0;
                        r = Integer.MIN_VALUE;
                        continue;
                    }
                    if (!blockState.method_26227().method_15769()) {
                        if (r != Integer.MIN_VALUE) continue;
                        r = u + 1;
                        continue;
                    }
                    if (s >= u) {
                        s = class_2874.field_35479;
                        for (v = u - 1; v >= t - 1; --v) {
                            blockState2 = blockColumn.method_32892(v);
                            if (this.isDefaultBlock(blockState2)) continue;
                            s = v + 1;
                            break;
                        }
                    }
                    v = u - s + 1;
                    ((MaterialRuleContextAccessor)(Object)materialRuleContext).callInitVerticalContext(++q, v, r, m, u, n);
                    if (blockState != this.defaultState || (blockState2 = blockStateRule.tryApply(m, u, n)) == null) continue;
                    blockColumn.method_38092(u, blockState2);
                }
                if (!registryEntry.method_40225(class_1972.field_9435) && !registryEntry.method_40225(class_1972.field_9418)) continue;
                this.placeIceberg(materialRuleContext.method_39551(), registryEntry.comp_349(), blockColumn, mutable2, m, n, o);
            }
        }
    }
}