package xyz.lynxs.terrarium.world.gen.biome;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import xyz.lynxs.terrarium.world.gen.HeightProvider;


import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_3756;
import net.minecraft.class_5284;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_6544;
import net.minecraft.class_6880;

import static xyz.lynxs.terrarium.Terrarium.CONFIG;
import static xyz.lynxs.terrarium.Util.truncate;
import static xyz.lynxs.terrarium.world.gen.BiomeProvider.getClimate;


public class TerrariumBiomeSource extends class_1966 {
    private final List<BiomeEntry> biomeEntries;
    private final class_3756 noiseSampler;
    private final class_6880<class_5284> settings;
    private final Double noiseScales;


    public static final Codec<TerrariumBiomeSource> field_24713 = RecordCodecBuilder.create(instance ->
            instance.group(
                    BiomeEntry.CODEC.listOf().fieldOf("biomes").forGetter(source -> source.biomeEntries),
                    class_5284.field_24781.fieldOf("settings").forGetter(source -> source.settings),
                    Codec.DOUBLE.fieldOf("noise_scale").forGetter(source -> source.noiseScales)
            ).apply(instance, TerrariumBiomeSource::new)
    );

    public TerrariumBiomeSource(List<BiomeEntry> biomeEntries, class_6880<class_5284> settings, Double noiseScales ) {
        this(biomeEntries, class_5819.method_43047(), settings, noiseScales);
    }

    public TerrariumBiomeSource(List<BiomeEntry> biomeEntries, class_5819 random, class_6880<class_5284> settings, Double noiseScales) {
        this.biomeEntries = biomeEntries;
        this.noiseSampler = new class_3756(random);
        this.settings = settings;
        this.noiseScales = noiseScales;
    }


    public record BiomeEntry(
            class_6880<class_1959> biome,
            double precipitation,
            double temperature,
            double noiseWeight
    ) {
        public static final Codec<BiomeEntry> CODEC = RecordCodecBuilder.create(instance ->
                instance.group(
                        class_1959.field_24677.fieldOf("biome").forGetter(BiomeEntry::biome),
                        Codec.DOUBLE.fieldOf("precipitation").forGetter(BiomeEntry::precipitation) ,
                        Codec.DOUBLE.fieldOf("temperature").forGetter(BiomeEntry::temperature),
                        Codec.DOUBLE.fieldOf("noise_weight").forGetter(BiomeEntry::noiseWeight)
                ).apply(instance, BiomeEntry::new)
        );
    }

    @Override
    protected Codec<? extends class_1966> method_28442() {
        return field_24713;
    }

    @Override
    protected Stream<class_6880<class_1959>> method_49494() {
        return biomeEntries.stream().map(BiomeEntry::biome);
    }


    @Override
    public class_6880<class_1959> method_38109(int x, int elevation, int z, class_6544.class_6552 noise) {
        int adjustedX = x + CONFIG.adjustXoffset;
        int adjustedZ = z + CONFIG.adjustZoffset;
        double precipitation = (adjustedX > 0 && adjustedZ > 0) && (adjustedX < HeightProvider.size && adjustedZ < HeightProvider.size) ? getClimate(adjustedX, adjustedZ, true) : 2;
        double temperature = (adjustedX > 0 && adjustedZ > 0) && (adjustedX < HeightProvider.size && adjustedZ < HeightProvider.size) ?  getClimate(adjustedX, adjustedZ, false) : 2;

        precipitation =  precipitation > 1 ? noise.method_40444(x, elevation, z).comp_113() : precipitation;
        temperature =  temperature > 1 ? noise.method_40444(x, elevation, z).comp_112() : temperature;

        return findBestBiome(precipitation, temperature, getNoiseValue(adjustedX, elevation, adjustedZ));
    }


    private double getNoiseValue(int x, int elevation, int z) {
        return noiseSampler.method_33658(x * CONFIG.noise_biome_scale, elevation * CONFIG.noise_biome_scale, z * CONFIG.noise_biome_scale);
    }

    private class_6880<class_1959> findBestBiome(double precip, double temperature, double noise) {
        if (biomeEntries.isEmpty()) {
            throw new IllegalStateException("No biomes available!");
        }

        return biomeEntries.stream()
                .min(Comparator.comparingDouble(b -> {
                    // Calculate squared Euclidean distance
                    double precipDiff = Math.pow(precip - b.precipitation(), 2) * 0.5;
                    double tempDiff = Math.pow(temperature - b.temperature(), 2) ;
                    double noiseDiff = Math.pow(noise - b.noiseWeight(), 2);
                    return Math.sqrt(precipDiff + tempDiff + noiseDiff);
                }))
                .orElseThrow() // Should not throw if biomeEntries is not empty
                .biome();
    }




    @Override
    public void method_38114(List<String> info, class_2338 pos, class_6544.class_6552 noiseSampler) {
        int i = class_5742.method_33100(pos.method_10263());
        int j = class_5742.method_33100(pos.method_10264());
        int k = class_5742.method_33100(pos.method_10260());
        int adjustedZ = k + CONFIG.adjustZoffset;
        int adjustedX = i + CONFIG.adjustXoffset;

        info.add(
                "Biome builder PV: "
                        + " Precipitation: "
                        + truncate((adjustedX > 0 && adjustedZ > 0) && (adjustedX < HeightProvider.size && adjustedZ < HeightProvider.size) ? getClimate(adjustedX, adjustedZ, true) : -1.000, 3)
                        + " Temperature: "
                        + truncate((adjustedX > 0 && adjustedZ > 0) && (adjustedX < HeightProvider.size && adjustedZ < HeightProvider.size) ? getClimate(adjustedX, adjustedZ, false) : -1.000, 3)
                        + " Noise: "
                        + truncate(getNoiseValue(i, j, k), 3)
        );
    }

}