package xyz.lynxs.terrarium.world.gen.chunk;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Codec;
import xyz.lynxs.terrarium.accessor.TerrariumSurfaceBuilderAccessor;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2922;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5485;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5817;
import net.minecraft.class_5820;
import net.minecraft.class_5868;
import net.minecraft.class_5873;
import net.minecraft.class_6350;
import net.minecraft.class_6568;
import net.minecraft.class_6643;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import net.minecraft.world.gen.chunk.*;
import xyz.lynxs.terrarium.world.gen.biome.TerrariumBiomeSource;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;

import static xyz.lynxs.terrarium.Terrarium.CONFIG;
import static xyz.lynxs.terrarium.Util.gridToLatLon;
import static xyz.lynxs.terrarium.world.gen.HeightProvider.*;

public class TerrariumChunkGenerator extends class_2794 {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    private final class_6880<class_5284> settings;

    private final TerrariumBiomeSource biomeSource;

    public TerrariumChunkGenerator(
            TerrariumBiomeSource biomeSource, // Use custom type instead of generic BiomeSource
            class_6880<class_5284> settings
    ) {
        super(biomeSource); // Pass to parent

        this.biomeSource = biomeSource; // Store reference
        this.settings = settings;
    }


    public int getFromMap(int x, int z) {
        // Center offset - assumes world center is land
        int adjustedX = x + CONFIG.adjustXoffset;
        int adjustedZ = z + CONFIG.adjustZoffset;

        if (adjustedX < 0 || adjustedZ < 0 || adjustedX > size || adjustedZ > size)
            return method_33730() - 1;

        return getElevation(adjustedX, adjustedZ) + CONFIG.startingY;
    }

    public class_6880<class_5284> getSettings() {
        return this.settings;
    }

    public static final Codec<TerrariumChunkGenerator> field_24746 = RecordCodecBuilder.create(
            instance -> instance.group(
                    TerrariumBiomeSource.CODEC // Use your biome source's CODEC
                            .fieldOf("biome_source")
                            .forGetter(TerrariumChunkGenerator::method_12098),
                    class_5284.field_24781
                            .fieldOf("settings")
                            .forGetter(TerrariumChunkGenerator::getSettings)
            ).apply(instance, TerrariumChunkGenerator::new)
    );

    public TerrariumBiomeSource method_12098() {
        return this.biomeSource;
    }

    /**
     */
    @Override
    protected Codec<? extends class_2794> method_28506() {
        return field_24746;
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk2, class_2893.class_2894 carverStep) {

        class_4543 biomeAccess2 = biomeAccess.method_38107((biomeX, biomeY, biomeZ) -> this.biomeSource.method_38109(biomeX, biomeY, biomeZ, noiseConfig.method_42371()));
        class_2919 chunkRandom = new class_2919(new class_5820(class_6673.method_39001()));
        int i = 8;
        class_1923 chunkPos = chunk2.method_12004();
        class_6568 chunkNoiseSampler = chunk2.method_38255(chunk -> this.createChunkNoiseSampler(chunk, structureAccessor, class_6748.method_39342(chunkRegion), noiseConfig));
        class_6350 aquiferSampler = chunkNoiseSampler.method_38354();
        class_5873 carverContext = new class_5873(new class_3754(this.biomeSource, this.settings),
                /*this is fine because the only thing the NCG is used for is like, the height limit or something*/
                chunkRegion.method_30349(), chunk2.method_39460(), chunkNoiseSampler, noiseConfig, this.settings.comp_349().comp_478());
        class_6643 carvingMask = ((class_2839) chunk2).method_28510(carverStep);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                class_1923 chunkPos2 = new class_1923(chunkPos.field_9181 + j, chunkPos.field_9180 + k);
                class_2791 chunk22 = chunkRegion.method_8392(chunkPos2.field_9181, chunkPos2.field_9180);
                class_6880<class_1959> biome = this.biomeSource.method_38109(class_5742.method_33100(chunkPos2.method_8326()), 0, class_5742.method_33100(chunkPos2.method_8328()), noiseConfig.method_42371());
                class_5485 generationSettings = chunk22.method_44214(() -> this.method_44216(biome));
                Iterable<class_6880<class_2922<?>>> iterable = generationSettings.method_30976(carverStep);
                int l = 0;
                for (class_6880<class_2922<?>> registryEntry : iterable) {
                    class_2922<?> configuredCarver = registryEntry.comp_349();
                    chunkRandom.method_12663(seed + (long) l, chunkPos2.field_9181, chunkPos2.field_9180);
                    if (configuredCarver.method_12669(chunkRandom)) {
                        configuredCarver.method_12668(carverContext, chunk2, biomeAccess2::method_22393, chunkRandom, aquiferSampler, chunkPos2, carvingMask);
                    }
                    ++l;
                }
            }
        }
    }

    @Override
    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
        if (class_155.method_37896(chunk.method_12004())) {
            return;
        }
        class_5868 heightContext = new class_5868(this, region);
        this.buildSurface(chunk, heightContext, noiseConfig, structures, region.method_22385(), region.method_30349().method_30530(class_7924.field_41236), class_6748.method_39342(region));
    }

    @VisibleForTesting
    public void buildSurface(class_2791 chunk, class_5868 heightContext, class_7138 noiseConfig, class_5138 structureAccessor, class_4543 biomeAccess, class_2378<class_1959> biomeRegistry, class_6748 blender) {
        class_6568 chunkNoiseSampler = chunk.method_38255(chunk3 -> this.createChunkNoiseSampler(chunk3, structureAccessor, blender, noiseConfig));
        class_5284 chunkGeneratorSettings = this.settings.comp_349();
        ((TerrariumSurfaceBuilderAccessor) noiseConfig.method_42372()).buildSurface(noiseConfig, biomeAccess, biomeRegistry, chunkGeneratorSettings.comp_483(), heightContext, chunk, chunkNoiseSampler, chunkGeneratorSettings.comp_478());
    }

    @Override
    public void method_12107(class_3233 region) {
        class_1923 chunkPos = region.method_33561();
        class_6880<class_1959> registryEntry = region.method_23753(chunkPos.method_8323().method_33096(region.method_31600() - 1));
        class_2919 chunkRandom = new class_2919(new class_5820(class_6673.method_39001()));
        chunkRandom.method_12661(region.method_8412(), chunkPos.method_8326(), chunkPos.method_8328());
        class_1948.method_8661(region, registryEntry, chunkPos, chunkRandom);
    }

    @Override
    public int method_12104() {
        return this.settings.comp_349().comp_474().comp_174();
    }

    @Override
    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        class_5309 generationShapeConfig = this.settings.comp_349().comp_474().method_42368(chunk.method_39460());
        int k = class_3532.method_48116(generationShapeConfig.comp_174(), generationShapeConfig.comp_179());
        if (k <= 0) {
            return CompletableFuture.completedFuture(chunk);
        }
        int x = (chunk.method_12004().field_9181 << 4) + CONFIG.adjustXoffset;
        int z = (chunk.method_12004().field_9180 << 4) + CONFIG.adjustZoffset;


        int minimumCellY = class_3532.method_48116(generationShapeConfig.comp_173(), generationShapeConfig.method_39545());
        int cellHeight = class_3532.method_48116(generationShapeConfig.comp_174(), generationShapeConfig.method_39545());
        if (x < -16 || z < -16) return CompletableFuture.completedFuture(chunk);
        return CompletableFuture.supplyAsync(class_156.method_37910("wgen_fill_noise", () -> this.populateNoise(chunk, structureAccessor, blender, noiseConfig, minimumCellY, cellHeight)), class_156.method_18349());
    }

    private class_2791 populateNoise(class_2791 chunk, class_5138 accessor, class_6748 blender, class_7138 noiseConfig, int minimumCellY, int cellHeight) {
        class_6568 chunkNoiseSampler = chunk.method_38255(chunk1 -> this.createChunkNoiseSampler(chunk, accessor, blender, noiseConfig));
        class_2902 oceanHeightmap = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightmap = chunk.method_12032(class_2902.class_2903.field_13194);
        class_1923 chunkPos = chunk.method_12004();
        int i = chunkPos.method_8326();
        int j = chunkPos.method_8328();
        chunkNoiseSampler.method_38336();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int k = chunkNoiseSampler.method_42361();
        int l = chunkNoiseSampler.method_42362();
        int m = 16 / k;
        int n = 16 / k;


        class_2680 defaultFluid = this.settings.comp_349().comp_476();
        for (int o = 0; o < m; ++o) {
            chunkNoiseSampler.method_38339(o);
            for (int p = 0; p < n; ++p) {
                int q1 = chunk.method_32890() - 1;
                class_2826 chunkSection = chunk.method_38259(q1);
                for (int q = cellHeight - 1; q >= 0; --q) {
                    chunkNoiseSampler.method_38362(q, p);
                    for (int r = l - 1; r >= 0; --r) {
                        int s = (minimumCellY + q) * l + r;
                        int t = s & 0xF;
                        int u = chunk.method_31602(s);
                        if (q1 != u) {
                            q1 = u;
                            chunkSection = chunk.method_38259(u);
                        }
                        double d = (double) r / (double) l;
                        chunkNoiseSampler.method_38337(s, d);
                        for (int v = 0; v < k; ++v) {
                            int w = i + o * k + v;
                            int x = w & 0xF;
                            double e = (double) v / (double) k;
                            chunkNoiseSampler.method_38349(w, e);
                            for (int y = 0; y < k; ++y) {

                                int z = j + p * k + y;
                                int aa = z & 0xF;
                                double f = (double) y / (double) k;
                                chunkNoiseSampler.method_38355(z, f);
                                int blockX = chunkNoiseSampler.comp_371();
                                int blockY = chunkNoiseSampler.comp_372();
                                int blockZ = chunkNoiseSampler.comp_373();

                                mutable.method_10103(blockX, blockY, blockZ);
                                int seaLevel = this.getSeaLevel(blockX, blockZ);
                                int elevation = getFromMap(blockX, blockZ);

                                class_2680 state;
                                if (elevation - blockY <= 10) {
                                    if (blockY <= seaLevel && blockY >= elevation) {
                                        state = defaultFluid;
                                    } else if (blockY < elevation) {
                                        state = this.settings.comp_349().comp_475(); //getBlock(blockX, blockZ, blockY);
                                    } else {
                                        state = AIR;
                                    }
                                    chunk.method_12010(mutable, state, false);
                                    surfaceHeightmap.method_12597(blockX & 0xF, blockY, blockZ & 0xF, state);
                                    oceanHeightmap.method_12597(blockX & 0xF, blockY, blockZ & 0xF, state);
                                } else {
                                    state = chunkNoiseSampler.method_40536();

                                    state = this.settings.comp_349().comp_475();

                                    if ((class_155.method_37896(chunk.method_12004())))
                                        continue;
                                    chunkSection.method_12256(x, t, aa, state, false);
                                    oceanHeightmap.method_12597(x, s, aa, state);
                                    surfaceHeightmap.method_12597(x, s, aa, state);
                                }
                                mutable.method_10103(w, s,z);
                                //if (!aquiferSampler.needsFluidTick() || state.getFluidState().isEmpty()) continue;
                                chunk.method_12039(mutable);
                                //buildSurface(chunk, new HeightContext(this, chunk.getHeightLimitView()),noiseConfig, accessor, null, accessor.getRegistryManager().get(), blender);
                            }
                        }
                    }
                }
            }
            chunkNoiseSampler.method_38348();
        }
        chunkNoiseSampler.method_40537();

        return chunk;
    }

    @Override
    public int method_16398() {
        return this.settings.comp_349().comp_479();
    }

    public int getSeaLevel(int x, int z) {
        return this.settings.comp_349().comp_479();
    }

    @Override
    public int method_33730() {
        return this.settings.comp_349().comp_474().comp_173();
    }

    @Override
    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return (
//                (heightmap == Heightmap.Type.OCEAN_FLOOR_WG || heightmap == Heightmap.Type.OCEAN_FLOOR)
//                        ? this.getFromMap(x, z, this.heightmap) :
//                Math.max(this.seaLevel,
                this.getFromMap(x, z)
//                )
        );
    }

    @Override
    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        int elevation = this.getFromMap(x, z);
        int seaLevel = this.getSeaLevel(x, z);
        if (elevation < this.method_33730())
            return new class_4966(world.method_31607(), new class_2680[]{class_2246.field_10124.method_9564()});
        if (elevation < seaLevel) {
            return new class_4966(
                    this.settings.comp_349().comp_474().comp_173(),
                    Stream.concat(
                            Stream.generate(() -> this.settings.comp_349().comp_475()).limit(elevation - this.method_33730()),
                            Stream.generate(() -> this.settings.comp_349().comp_476()).limit(seaLevel - elevation - this.method_33730())
                    ).toArray(class_2680[]::new));
        }
        return new class_4966(
                this.settings.comp_349().comp_474().comp_173(),
                Stream.generate(() -> this.settings.comp_349().comp_475()).limit(elevation - this.method_33730() + 1).toArray(class_2680[]::new)

        );
    }

    @Override
    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
        text.add(
                "[Terrarium] Elevation: " + getFromMap(pos.method_10263(), pos.method_10260()) +
                        ", Cords: " + Arrays.toString(gridToLatLon(pos.method_10263() + CONFIG.adjustXoffset, pos.method_10260() + CONFIG.adjustZoffset, size))
        );
    }

    private class_6568 createChunkNoiseSampler(class_2791 chunk, class_5138 world, class_6748 blender, class_7138 noiseConfig) {
        return class_6568.method_39543(
                chunk,
                noiseConfig,
                class_5817.method_42695(world, chunk.method_12004()),
                this.settings.comp_349(),
                (x, y, z) -> new class_6350.class_6351(method_16398(), settings.comp_349().comp_476()),
                blender
        );
    }

}
