/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.lynxs.terrarium.ConfigManager;
import xyz.lynxs.terrarium.TerrariumConfig;
import xyz.lynxs.terrarium.Util;
import xyz.lynxs.terrarium.gen.BiomeProvider;
import xyz.lynxs.terrarium.gen.HeightProvider;
import xyz.lynxs.terrarium.preset.PresetConfig;

public final class Terrarium {
    public static final String MOD_ID = "terrarium";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"terrarium");
    public static PresetConfig CONFIG = new PresetConfig();
    public static TerrariumConfig CONFIG1 = ConfigManager.register(TerrariumConfig.class, Path.of("terrarium.json", new String[0]), newConfig -> {
        CONFIG1 = newConfig;
    });

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void onServerWorldLoad(MinecraftServer server) {
        CONFIG = (PresetConfig)TerrariumConfig.load(CONFIG.getClass(), server.getWorldPath(LevelResource.ROOT).resolve("terrarium.json"), false);
        LOGGER.info("Terrarium World Loaded!");
    }

    public static void init() {
        CommandRegistrationEvent.EVENT.register((commandDispatcher, commandBuildContext, commandSelection) -> Terrarium.register((CommandDispatcher<CommandSourceStack>)commandDispatcher));
        LOGGER.info("Terrarium mod initialized");
        LifecycleEvent.SERVER_LEVEL_LOAD.register(k -> Terrarium.onServerWorldLoad(k.getServer()));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ecoregion").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (source.getEntity() == null) {
                source.sendFailure((Component)Component.literal((String)"This command can only be used by a player"));
                return 0;
            }
            BlockPos pos = source.getEntity().blockPosition();
            String region = String.valueOf(BiomeProvider.getClimate(pos.getX(), pos.getZ()));
            source.sendSuccess(() -> Component.literal((String)("Current Region: " + region)), false);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"geotp").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"longitude", (ArgumentType)DoubleArgumentType.doubleArg((double)-180.0, (double)180.0)).then(Commands.argument((String)"latitude", (ArgumentType)DoubleArgumentType.doubleArg((double)-90.0, (double)90.0)).executes(context -> Terrarium.teleportToCoordinates((CommandSourceStack)context.getSource(), DoubleArgumentType.getDouble((CommandContext)context, (String)"longitude"), DoubleArgumentType.getDouble((CommandContext)context, (String)"latitude"))))).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing latitude argument. Usage: /geotp <longitude> <latitude>"));
            return 0;
        }))).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Usage: /geotp <longitude> <latitude> - Teleports to geographic coordinates"));
            return 0;
        }));
    }

    private static int teleportToCoordinates(CommandSourceStack source, double longitude, double latitude) {
        Entity entity;
        if (source == null || !((entity = source.getEntity()) instanceof Player)) {
            if (source != null) {
                source.sendFailure((Component)Component.literal((String)"Only players can use this command!"));
            }
            return 0;
        }
        Player player = (Player)entity;
        try {
            int x = Util.lonToX(longitude, (int)(Math.pow(2.0, Terrarium.CONFIG.zoom) * 256.0)) - Terrarium.CONFIG.adjustXoffset;
            int z = Util.latToZ(latitude, (int)(Math.pow(2.0, Terrarium.CONFIG.zoom) * 256.0)) - Terrarium.CONFIG.adjustZoffset;
            int y = HeightProvider.getElevation(x, z) + Terrarium.CONFIG.startingY;
            if (y < source.getLevel().getMinY()) {
                source.sendFailure((Component)Component.literal((String)"Could not find a safe location to teleport to!"));
                return 0;
            }
            player.teleportTo((double)x + 0.5, (double)(y += 65), (double)z + 0.5);
            int finalY = y;
            source.sendSuccess(() -> Component.literal((String)String.format("Teleported to %.6f\u00b0 longitude, %.6f\u00b0 latitude (Minecraft coordinates: %d, %d, %d)", longitude, latitude, x, finalY, z)), false);
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("An error occurred during teleportation: " + e.getMessage())));
            return 0;
        }
    }
}

