/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gen;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.Util;

public class BiomeProvider {
    private static final String CACHE_DIR = "/biomes/";
    private static final Logger LOGGER = Terrarium.LOGGER;
    private static final int QUALITY = 7;
    private static final ExecutorService IO_EXECUTOR = Executors.newFixedThreadPool(4, new NamedThreadFactory("Terrarium-Biome-Loader"));
    private static final Map<Long, Future<int[][]>> biomeFutures = new ConcurrentHashMap<Long, Future<int[][]>>();
    private static final int[][] DUMMY_BIOME_ARRAY = new int[256][256];
    private static final Map<Integer, Double> biomeHumidity = new ConcurrentHashMap<Integer, Double>();
    private static final Map<Integer, Double> biomeTemperature = new ConcurrentHashMap<Integer, Double>();

    public static void init() {
        biomeHumidity.put(6072275, -0.33);
        biomeHumidity.put(11655278, 0.5);
        biomeHumidity.put(49408, 0.33);
        biomeHumidity.put(1737786, 0.3);
        biomeHumidity.put(8971063, -0.33);
        biomeHumidity.put(14732139, -0.75);
        biomeHumidity.put(14440537, 0.0);
        biomeHumidity.put(6379956, -0.25);
        biomeHumidity.put(11765807, -0.25);
        biomeHumidity.put(7767588, 0.66);
        biomeHumidity.put(11649118, -0.25);
        biomeHumidity.put(79104, 0.75);
        biomeTemperature.put(6072275, -0.66);
        biomeTemperature.put(11655278, -0.33);
        biomeTemperature.put(49408, 0.0);
        biomeTemperature.put(1737786, -0.2);
        biomeTemperature.put(8971063, 0.33);
        biomeTemperature.put(14732139, 0.9);
        biomeTemperature.put(14440537, 0.33);
        biomeTemperature.put(6379956, 0.5);
        biomeTemperature.put(11765807, 0.25);
        biomeTemperature.put(7767588, 0.0);
        biomeTemperature.put(11649118, 0.66);
        biomeTemperature.put(79104, 0.33);
    }

    private static BufferedImage getClimateTileImage(int xTile, int zTile, Path cachePath, URI path) {
        BufferedImage bufferedImage;
        block13: {
            URI uri = path.resolve("7/" + xTile + "/" + zTile + ".png");
            File cacheFile = cachePath.resolve("7/" + xTile + "/" + zTile + ".png").toFile();
            if (cacheFile.exists()) {
                try {
                    return ImageIO.read(cacheFile);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load biome tile from cache: {}", (Object)e.getMessage());
                }
            }
            InputStream inputStream = uri.toURL().openStream();
            try {
                BufferedImage tileImage = ImageIO.read(inputStream);
                if (tileImage == null) {
                    throw new IOException("Failed to read image from URL: " + String.valueOf(uri));
                }
                Path cacheDir = Paths.get(cacheFile.getParent(), new String[0]);
                if (!Files.exists(cacheDir, new LinkOption[0])) {
                    Files.createDirectories(cacheDir, new FileAttribute[0]);
                }
                ImageIO.write((RenderedImage)tileImage, "png", cacheFile);
                bufferedImage = tileImage;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to download biome tile: {}", (Object)e.getMessage());
                    return new BufferedImage(256, 256, 1);
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    private static int[][] toByteArr(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] arr = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                arr[y][x] = image.getRGB(x, y) & 0xFFFFFF;
            }
        }
        return arr;
    }

    private static int[][] loadBiomeTile(int xTile, int zTile) {
        BufferedImage image = BiomeProvider.getClimateTileImage(xTile, zTile, Path.of(Terrarium.CONFIG1.CACHE_DIR + CACHE_DIR, new String[0]), Terrarium.CONFIG1.BIOME_URL);
        return BiomeProvider.toByteArr(image);
    }

    private static int[][] getBiomeArrayBlocking(int xTile, int zTile) {
        long key = Util.pack(xTile, zTile);
        Future future = biomeFutures.computeIfAbsent(key, k -> {
            LOGGER.debug("Submitting biome tile load task for ({}, {}) to background executor.", (Object)xTile, (Object)zTile);
            return IO_EXECUTOR.submit(() -> BiomeProvider.loadBiomeTile(xTile, zTile));
        });
        try {
            return (int[][])future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Thread interrupted while waiting for biome tile ({}, {}).", (Object)xTile, (Object)zTile);
            biomeFutures.remove(key);
            return DUMMY_BIOME_ARRAY;
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to execute biome tile load task for ({}, {}): {}", new Object[]{xTile, zTile, e.getCause().getMessage()});
            biomeFutures.remove(key);
            return DUMMY_BIOME_ARRAY;
        }
    }

    private static int getBiomeKeyAtScaledCoord(int scaledX, int scaledZ) {
        int Xtile = scaledX >> 8;
        int Ztile = scaledZ >> 8;
        int localX = scaledX & 0xFF;
        int localZ = scaledZ & 0xFF;
        int[][] biomeArray = BiomeProvider.getBiomeArrayBlocking(Xtile, Ztile);
        if (localZ >= 0 && localZ < biomeArray.length && localX >= 0 && localX < biomeArray[localZ].length) {
            return biomeArray[localZ][localX];
        }
        return DUMMY_BIOME_ARRAY[0][0];
    }

    public static int getClimate(int xx, int zz) {
        int x = xx + Terrarium.CONFIG.adjustXoffset;
        int z = zz + Terrarium.CONFIG.adjustZoffset;
        double scale = Math.pow(2.0, 7 - Terrarium.CONFIG.zoom);
        double preciseScaledX = (double)x * scale;
        double preciseScaledZ = (double)z * scale;
        int scaledX0 = (int)Math.floor(preciseScaledX);
        int scaledZ0 = (int)Math.floor(preciseScaledZ);
        double u = preciseScaledX - (double)scaledX0;
        double v = preciseScaledZ - (double)scaledZ0;
        int c00 = BiomeProvider.getBiomeKeyAtScaledCoord(scaledX0, scaledZ0);
        int c10 = BiomeProvider.getBiomeKeyAtScaledCoord(scaledX0 + 1, scaledZ0);
        int c01 = BiomeProvider.getBiomeKeyAtScaledCoord(scaledX0, scaledZ0 + 1);
        int c11 = BiomeProvider.getBiomeKeyAtScaledCoord(scaledX0 + 1, scaledZ0 + 1);
        double w00 = (1.0 - u) * (1.0 - v);
        double w10 = u * (1.0 - v);
        double w01 = (1.0 - u) * v;
        double w11 = u * v;
        int result = c00;
        double maxWeight = w00;
        if (w10 > maxWeight) {
            maxWeight = w10;
            result = c10;
        }
        if (w01 > maxWeight) {
            maxWeight = w01;
            result = c01;
        }
        if (w11 > maxWeight) {
            result = c11;
        }
        return result;
    }

    public static double getHumidity(int xx, int zz) {
        int clim = BiomeProvider.getClimate(xx, zz);
        if (!biomeHumidity.containsKey(clim)) {
            LOGGER.error("No key for humidity: {}", (Object)clim);
        }
        return biomeHumidity.getOrDefault(clim, 0.0);
    }

    public static double getTemperature(int xx, int zz) {
        return biomeTemperature.getOrDefault(BiomeProvider.getClimate(xx, zz), 0.0);
    }

    public static short getTreeline(int xx, int zz) {
        int x = xx + Terrarium.CONFIG.adjustXoffset;
        int z = zz + Terrarium.CONFIG.adjustZoffset;
        return 256;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private int count = 0;

        public NamedThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread t = new Thread(r, this.namePrefix + "-" + this.count++);
            t.setDaemon(true);
            return t;
        }
    }
}

