/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.jetbrains.annotations.NotNull;
import xyz.lynxs.terrarium.Terrarium;

public class DynamicHeightPlacement
extends PlacementModifier {
    private final HeightProvider height;
    public static final MapCodec<DynamicHeightPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HeightProvider.CODEC.fieldOf("height").forGetter(heightRangePlacement -> heightRangePlacement.height)).apply((Applicative)instance, DynamicHeightPlacement::new));

    public DynamicHeightPlacement(HeightProvider height) {
        this.height = height;
    }

    public static DynamicHeightPlacement of(HeightProvider heightProvider) {
        return new DynamicHeightPlacement(heightProvider);
    }

    public static DynamicHeightPlacement uniform(VerticalAnchor verticalAnchor, VerticalAnchor verticalAnchor2) {
        return DynamicHeightPlacement.of((HeightProvider)UniformHeight.of((VerticalAnchor)verticalAnchor, (VerticalAnchor)verticalAnchor2));
    }

    public static DynamicHeightPlacement triangle(VerticalAnchor verticalAnchor, VerticalAnchor verticalAnchor2) {
        return DynamicHeightPlacement.of((HeightProvider)TrapezoidHeight.of((VerticalAnchor)verticalAnchor, (VerticalAnchor)verticalAnchor2));
    }

    @NotNull
    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        int y = this.height.sample(random, (WorldGenerationContext)context);
        y = y <= 64 ? y : y / (Terrarium.CONFIG.worldHeight + Terrarium.CONFIG.startingY) * 320;
        return Stream.of(pos.atY(y));
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return PlacementModifierType.HEIGHT_RANGE;
    }
}

