/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gen;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.Util;

public class HeightProvider {
    private static final String ELEV_CACHE_DIR = "/elevation/";
    private static final String WATER_CACHE_DIR = "/water/";
    private static final Logger LOGGER = Terrarium.LOGGER;
    public static int size = (int)(256.0 * Math.pow(2.0, Terrarium.CONFIG.zoom));
    private static final ExecutorService IO_EXECUTOR = Executors.newFixedThreadPool(4);
    private static final Map<Long, Future<TileData>> tileFutures = new ConcurrentHashMap<Long, Future<TileData>>();

    private static TileData loadAndComputeTile(int xTile, int zTile) {
        BufferedImage image = HeightProvider.getElevationFromHeightmap(xTile, zTile, Path.of(Terrarium.CONFIG1.CACHE_DIR + ELEV_CACHE_DIR, new String[0]), Terrarium.CONFIG1.ELEVATION_URL);
        short[][] elevation = HeightProvider.toIntHeightmap(image);
        float[][] steepness = HeightProvider.computeSteepnessMap(elevation);
        short maxElevation = HeightProvider.computeMax(elevation);
        return new TileData(elevation, steepness, maxElevation);
    }

    private static TileData getTileBlocking(int xTile, int zTile) {
        long key = Util.pack(xTile, zTile);
        Future future = tileFutures.computeIfAbsent(key, k -> {
            LOGGER.debug("Submitting tile load task for ({}, {}) to background executor.", (Object)xTile, (Object)zTile);
            return IO_EXECUTOR.submit(() -> HeightProvider.loadAndComputeTile(xTile, zTile));
        });
        try {
            return (TileData)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Thread interrupted while waiting for tile ({}, {}).", (Object)xTile, (Object)zTile);
            tileFutures.remove(key);
            return TileData.DUMMY;
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to execute tile load task for ({}, {}): {}", new Object[]{xTile, zTile, e.getCause().getMessage()});
            tileFutures.remove(key);
            return TileData.DUMMY;
        }
    }

    public static void init() {
        size = (int)(256.0 * Math.pow(2.0, Terrarium.CONFIG.zoom));
    }

    private static BufferedImage getElevationFromHeightmap(int xTile, int zTile, Path cachePath, URI path) {
        BufferedImage bufferedImage;
        block13: {
            URI uri = path.resolve(Terrarium.CONFIG.zoom + "/" + xTile + "/" + zTile + ".png");
            File cacheFile = cachePath.resolve(Terrarium.CONFIG.zoom + "/" + xTile + "/" + zTile + ".png").toFile();
            if (cacheFile.exists()) {
                try {
                    return ImageIO.read(cacheFile);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load tile from cache: {}", (Object)e.getMessage());
                }
            }
            InputStream inputStream = uri.toURL().openStream();
            try {
                BufferedImage tileImage = ImageIO.read(inputStream);
                if (tileImage == null) {
                    throw new IOException("Failed to read image from URL: " + String.valueOf(uri));
                }
                Path cacheDir = Paths.get(cacheFile.getParent(), new String[0]);
                if (!Files.exists(cacheDir, new LinkOption[0])) {
                    Files.createDirectories(cacheDir, new FileAttribute[0]);
                }
                ImageIO.write((RenderedImage)tileImage, "png", cacheFile);
                bufferedImage = tileImage;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to download tile: {}", (Object)e.getMessage());
                    return new BufferedImage(256, 256, 1);
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    private static short[][] toIntHeightmap(BufferedImage image) {
        short[][] arr = new short[image.getWidth()][image.getHeight()];
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int rgb = image.getRGB(i, j);
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                double elevation = (double)(red * 256 + green) + (double)blue / 256.0 - 32768.0;
                arr[i][j] = (short)(elevation / 8850.0 * (double)Terrarium.CONFIG.worldHeight);
            }
        }
        return arr;
    }

    public static float[][] computeSteepnessMap(short[][] elevationTile) {
        int size = elevationTile.length;
        float[][] steepness = new float[size][size];
        for (int x = 1; x < size - 1; ++x) {
            for (int z = 1; z < size - 1; ++z) {
                float dx = (float)(elevationTile[x + 1][z] - elevationTile[x - 1][z]) / 2.0f;
                float dz = (float)(elevationTile[x][z + 1] - elevationTile[x][z - 1]) / 2.0f;
                steepness[x][z] = (float)Math.sqrt(dx * dx + dz * dz);
            }
        }
        return steepness;
    }

    public static short computeMax(short[][] elevationTile) {
        if (elevationTile == null || elevationTile.length == 0 || elevationTile[0].length == 0) {
            return Short.MIN_VALUE;
        }
        short maxElevation = Short.MIN_VALUE;
        short[][] sArray = elevationTile;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            short[] row;
            for (short value : row = sArray[i]) {
                if (value <= maxElevation) continue;
                maxElevation = value;
            }
        }
        return maxElevation;
    }

    public static short getElevation(int xx, int zz) {
        int x = xx + Terrarium.CONFIG.adjustXoffset;
        int z = zz + Terrarium.CONFIG.adjustZoffset;
        TileData tile = HeightProvider.getTileBlocking(x >> 8, z >> 8);
        return tile.elevation[x & 0xFF][z & 0xFF];
    }

    public static float getSteepness(int xx, int zz) {
        int x = xx + Terrarium.CONFIG.adjustXoffset;
        int z = zz + Terrarium.CONFIG.adjustZoffset;
        TileData tile = HeightProvider.getTileBlocking(x >> 8, z >> 8);
        return tile.steepness[x & 0xFF][z & 0xFF];
    }

    public static short getMax(int xx, int zz) {
        int x = xx + Terrarium.CONFIG.adjustXoffset;
        int z = zz + Terrarium.CONFIG.adjustZoffset;
        TileData tile = HeightProvider.getTileBlocking(x >> 8, z >> 8);
        return tile.maxElevation;
    }

    public record TileData(short[][] elevation, float[][] steepness, short maxElevation) {
        public static final TileData DUMMY = new TileData(new short[256][256], new float[256][256], 0);
    }
}

