/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gen.dfs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;
import xyz.lynxs.terrarium.gen.HeightProvider;

public record ContinentalnessDensity(double depth) implements DensityFunction.SimpleFunction
{
    public static final KeyDispatchDataCodec<ContinentalnessDensity> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("depth", (Object)20.0).forGetter(ContinentalnessDensity::depth)).apply((Applicative)instance, ContinentalnessDensity::new)));

    public double compute(DensityFunction.FunctionContext pos) {
        return Mth.clamp((double)(((double)HeightProvider.getMax(pos.blockX(), pos.blockZ()) - ((double)HeightProvider.getElevation(pos.blockX(), pos.blockZ()) + this.depth)) * -1.0), (double)(this.depth * -1.0), (double)this.depth) / this.depth;
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

