/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gen.dfs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;
import xyz.lynxs.terrarium.gen.BiomeProvider;

public record TemperatureDensity(DensityFunction noise) implements DensityFunction.SimpleFunction
{
    public static final KeyDispatchDataCodec<TemperatureDensity> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.DIRECT_CODEC.fieldOf("noise").forGetter(TemperatureDensity::noise)).apply((Applicative)instance, TemperatureDensity::new)));

    public double compute(DensityFunction.FunctionContext pos) {
        return BiomeProvider.getTemperature(pos.blockX(), pos.blockZ()) + this.noise.compute(pos) / 5.0;
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }

    @NotNull
    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new TemperatureDensity(this.noise.mapAll(visitor)));
    }
}

