/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gui;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class Slider
extends AbstractSliderButton {
    private final double min;
    private final double max;
    private final Component name;
    private final Format format;
    @Nullable
    private final Callback callback;

    public Slider(int x, int y, int width, int height, float initialValue, float min, float max, Component name, Format format, @Nullable Callback callback) {
        super(x, y, width, height, (Component)Component.empty(), 0.0);
        this.name = name;
        this.format = format;
        this.min = min;
        this.max = max;
        this.value = this.getSliderValue(initialValue);
        this.callback = callback;
        this.updateMessage();
    }

    public double getSliderValue(float value) {
        return (Mth.clamp((double)value, (double)this.min, (double)this.max) - this.min) / (this.max - this.min);
    }

    public double lerpValue(double value) {
        return Mth.lerp((double)value, (double)this.min, (double)this.max);
    }

    public double scaleValue(double value) {
        return this.format.scale(this.lerpValue(value));
    }

    public void setSliderValue(float value) {
        this.value = this.getSliderValue(value);
        this.applyValue();
        this.updateMessage();
    }

    public void applyValue() {
        if (this.callback != null) {
            this.value = this.callback.apply(this, this.value);
        }
    }

    protected void updateMessage() {
        this.setMessage((Component)CommonComponents.optionNameValue((Component)this.name, (Component)Component.literal((String)this.format.getMessage(this.scaleValue((float)this.value)))));
    }

    public static enum Format {
        INT{

            @Override
            public double scale(double input) {
                return (int)input;
            }

            @Override
            public String getMessage(double input) {
                return String.valueOf((int)input);
            }
        }
        ,
        FLOAT{

            @Override
            public double scale(double input) {
                return input;
            }

            @Override
            public String getMessage(double input) {
                return String.format("%.3f", input);
            }
        };


        public abstract double scale(double var1);

        public abstract String getMessage(double var1);
    }

    public static interface Callback {
        public double apply(Slider var1, double var2);
    }
}

