/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gui;

import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.TerrariumConfig;
import xyz.lynxs.terrarium.Util;
import xyz.lynxs.terrarium.gen.BiomeProvider;
import xyz.lynxs.terrarium.gen.HeightProvider;
import xyz.lynxs.terrarium.gui.Slider;
import xyz.lynxs.terrarium.gui.TerrariumScrollableWidget;
import xyz.lynxs.terrarium.preset.PresetConfig;

public class TerrariumCustomizeScreen
extends Screen {
    private final CreateWorldScreen parent;
    private Button doneButton;
    private Button cancelButton;
    private Slider zoomSlider;
    private Slider worldHeightSlider;
    private Slider xOffsetSlider;
    private Slider zOffsetSlider;
    private final PresetConfig config;
    private TerrariumScrollableWidget scrollWidget;

    public TerrariumCustomizeScreen(CreateWorldScreen parent) {
        super((Component)Component.translatable((String)"terrarium.text.config_title"));
        this.parent = parent;
        this.config = new PresetConfig();
    }

    protected void init() {
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonPadding = 5;
        int panelWidth = this.width;
        int panelHeight = this.height - 75;
        int contentHeight = this.height;
        this.scrollWidget = new TerrariumScrollableWidget(this, this.minecraft, this.width / 2 - panelWidth / 2, 30, panelWidth, panelHeight, contentHeight){

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            }

            protected int contentHeight() {
                return 0;
            }

            protected double scrollRate() {
                return 10.0;
            }

            @Override
            protected void renderContents(GuiGraphics context, int mouseX, int mouseY, float delta) {
                super.renderContents(context, mouseX, (int)((double)mouseY + this.getScrollAmount()), delta);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.scrollWidget);
        this.bottomPanel(buttonWidth, buttonHeight, buttonPadding);
        this.Settings();
    }

    private void Settings() {
        int sliderPadding = 5;
        int sliderWidth = this.width - 2 * sliderPadding;
        int sliderHeight = 20;
        Objects.requireNonNull(this.font);
        this.worldHeightSlider = new Slider(sliderPadding, 9 + sliderPadding * 2 + sliderHeight * 2, sliderWidth, sliderHeight, this.config.worldHeight, 4.0f, 4096.0f, (Component)Component.translatable((String)"terrarium.text.slider.world_height"), Slider.Format.INT, (slider, value) -> {
            this.config.worldHeight = (int)slider.scaleValue(value);
            return value;
        });
        Objects.requireNonNull(this.font);
        this.xOffsetSlider = new Slider(sliderPadding, 9 + sliderPadding * 4 + sliderHeight * 4, sliderWidth, sliderHeight, Util.xToLon(this.config.adjustXoffset, (int)(256.0 * Math.pow(2.0, this.config.zoom))), -180.0f, 180.0f, (Component)Component.translatable((String)"terrarium.text.slider.x_offset"), Slider.Format.FLOAT, (slider, value) -> {
            this.config.adjustXoffset = Util.lonToX(slider.scaleValue(value), (int)(256.0 * Math.pow(2.0, this.config.zoom)));
            return value;
        });
        Objects.requireNonNull(this.font);
        this.zOffsetSlider = new Slider(sliderPadding, 9 + sliderPadding * 5 + sliderHeight * 5, sliderWidth, sliderHeight, Util.zToLat(this.config.adjustZoffset, (int)(256.0 * Math.pow(2.0, this.config.zoom))), -82.0f, 82.0f, (Component)Component.translatable((String)"terrarium.text.slider.z_offset"), Slider.Format.FLOAT, (slider, value) -> {
            this.config.adjustZoffset = Util.latToZ(slider.scaleValue(value), (int)(256.0 * Math.pow(2.0, this.config.zoom)));
            return value;
        });
        Objects.requireNonNull(this.font);
        this.zoomSlider = new Slider(sliderPadding, 9 + sliderPadding + sliderHeight, sliderWidth, sliderHeight, this.config.zoom, 0.0f, 15.0f, (Component)Component.translatable((String)"terrarium.text.slider.zoom"), Slider.Format.INT, (slider, value) -> {
            int newVal = (int)slider.scaleValue(value);
            this.config.adjustXoffset = (int)((double)this.config.adjustXoffset * Math.pow(2.0, this.config.zoom - newVal));
            this.config.adjustZoffset = (int)((double)this.config.adjustZoffset * Math.pow(2.0, this.config.zoom - newVal));
            this.config.zoom = newVal;
            this.worldHeightSlider.setSliderValue((float)(Math.pow(2.0, this.config.zoom) / 10.0));
            return value;
        });
        this.scrollWidget.addChild(this.zoomSlider);
        this.scrollWidget.addChild(this.worldHeightSlider);
        this.scrollWidget.addChild(this.xOffsetSlider);
        this.scrollWidget.addChild(this.zOffsetSlider);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
    }

    private void bottomPanel(int buttonWidth, int buttonHeight, int buttonPadding) {
        assert (this.minecraft != null);
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, btn -> {
            Terrarium.CONFIG = this.config;
            TerrariumConfig.save(Terrarium.CONFIG, Path.of("./saves/" + this.parent.getUiState().getTargetFolder() + "/terrarium.json", new String[0]), false);
            HeightProvider.init();
            BiomeProvider.init();
            Thread thread = new Thread(() -> {
                Terrarium.LOGGER.info("Preloading Initial Data...");
                HeightProvider.getElevation(0, 0);
                HeightProvider.getSteepness(0, 0);
                BiomeProvider.getTemperature(0, 0);
                BiomeProvider.getHumidity(0, 0);
            }, "terrarium_DATA_PRELOADING");
            thread.start();
            this.minecraft.setScreen((Screen)this.parent);
        }).bounds(this.width / 2 - (buttonWidth + buttonPadding), this.height - (buttonPadding + buttonHeight), buttonWidth, buttonHeight).build();
        this.cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, btn -> {
            Terrarium.CONFIG = new PresetConfig();
            this.minecraft.setScreen((Screen)this.parent);
        }).bounds(this.width / 2 + buttonPadding, this.height - (buttonPadding + buttonHeight), buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
    }
}

