/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollArea;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public abstract class TerrariumScrollableWidget
extends AbstractScrollArea {
    private double scrollAmount;
    private boolean scrolling;
    private final int contentHeight;
    @Nullable
    private Runnable onScroll;
    private final List<AbstractWidget> childWidgets = new ArrayList<AbstractWidget>();

    public TerrariumScrollableWidget(Minecraft client, int x, int y, int width, int height, int contentHeight) {
        super(x, y, width, height, (Component)Component.empty());
        this.contentHeight = contentHeight;
    }

    public <T extends AbstractWidget> void addChild(T widget) {
        this.childWidgets.add(widget);
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        context.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        context.pose().pushMatrix();
        context.pose().translate(0.0f, (float)(-this.scrollAmount), new Matrix3x2f());
        this.renderBackground(context, mouseX, mouseY, delta);
        this.renderContents(context, mouseX, mouseY, delta);
        context.pose().popMatrix();
        context.disableScissor();
        this.renderScrollBar(context);
    }

    protected void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    protected void renderContents(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.pose().pushMatrix();
        context.pose().translate(0.0f, (float)(-this.scrollAmount), new Matrix3x2f());
        for (AbstractWidget widget : this.childWidgets) {
            widget.render(context, mouseX, (int)((double)mouseY + this.getScrollAmount()), delta);
        }
        context.pose().popMatrix();
    }

    protected void renderScrollBar(GuiGraphics context) {
        int scrollBarWidth = 6;
        int scrollBarX = this.getX() + this.width - scrollBarWidth - 2;
        context.fill(scrollBarX, this.getY(), scrollBarX + scrollBarWidth, this.getY() + this.height, -10461088);
        int thumbHeight = Math.max(30, (int)((float)this.height / (float)this.contentHeight * (float)this.height));
        int thumbY = this.getY() + (int)(this.scrollAmount / (double)(this.contentHeight - this.height) * (double)(this.height - thumbHeight));
        context.fill(scrollBarX, thumbY, scrollBarX + scrollBarWidth, thumbY + thumbHeight, -4144960);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || !this.active) {
            return false;
        }
        for (AbstractWidget widget : this.childWidgets) {
            if (!widget.mouseClicked(mouseX, mouseY + 2.0 * this.getScrollAmount(), button)) continue;
            return true;
        }
        if (button == 0 && mouseX >= (double)(this.getX() + this.width - 6)) {
            this.scrolling = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.visible || !this.active) {
            return false;
        }
        for (AbstractWidget widget : this.childWidgets) {
            if (!widget.mouseClicked(mouseX, mouseY + 2.0 * this.getScrollAmount(), button)) continue;
            return true;
        }
        if (this.scrolling) {
            double scrollableHeight = this.contentHeight - this.height;
            double scrollDelta = deltaY / (double)this.height * scrollableHeight;
            this.setScrollAmount(this.scrollAmount + scrollDelta);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.visible || !this.active) {
            return false;
        }
        this.setScrollAmount(this.scrollAmount - verticalAmount * 20.0);
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.mouseReleased(mouseX, mouseY + this.getScrollAmount(), button);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = Mth.clamp((double)amount, (double)0.0, (double)Math.max(0, this.contentHeight - this.height));
        if (this.onScroll != null) {
            this.onScroll.run();
        }
    }

    public void setOnScroll(@Nullable Runnable onScroll) {
        this.onScroll = onScroll;
    }
}

