/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class TerrariumConfig {
    public URI ELEVATION_URL = URI.create("https://s3.amazonaws.com/elevation-tiles-prod/terrarium/");
    public URI WATER_URL = URI.create("https://data.lynxs.xyz/water/");
    public URI BIOME_URL = URI.create("https://data.lynxs.xyz/biome/");
    public String CACHE_DIR = "./tiles";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();

    private static File getFile(Path filename, boolean type) {
        return type ? FabricLoader.getInstance().getConfigDir().resolve(filename).toFile() : filename.toFile();
    }

    @NotNull
    public static <T> T load(Class<T> clazz, Path filename, boolean type) {
        File file = TerrariumConfig.getFile(filename, type);
        Object config = null;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                config = GSON.fromJson((Reader)reader, clazz);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (config == null) {
            try {
                config = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        TerrariumConfig.save(config, filename, type);
        return (T)config;
    }

    public static <T> void save(T config, Path filename, boolean type) {
        File file = TerrariumConfig.getFile(filename, type);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdir()) {
            System.err.println("Failed to create a directory for " + String.valueOf(file));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

