/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium;

public class Util {
    private static final double EARTH_RADIUS = 6378137.0;
    private static final double MAX_MERCATOR = 2.0037508342789244E7;
    private static final double MAX_LAT = 85.05112878;

    public static int latToZ(double latitude, int maxSize) {
        latitude = Math.max(-85.05112878, Math.min(85.05112878, latitude));
        double latRad = Math.toRadians(latitude);
        double mercatorY = Math.log(Math.tan(0.7853981633974483 + latRad / 2.0));
        double normalized = (1.0 - mercatorY / Math.PI) / 2.0;
        int z = (int)Math.floor(normalized * (double)maxSize);
        return Math.max(0, Math.min(maxSize - 1, z));
    }

    public static int lonToX(double longitude, int maxSize) {
        double normalized = (longitude + 180.0) / 360.0;
        int x = (int)Math.floor(normalized * (double)maxSize);
        return Math.max(0, Math.min(maxSize - 1, x));
    }

    public static double[] gridToLatLon(int x, int z, int maxSize) {
        double normalizedX = (double)x / (double)(maxSize - 1) * 2.0 - 1.0;
        double lon = normalizedX * 180.0;
        double normalizedZ = 1.0 - (double)z / (double)(maxSize - 1);
        double mercatorZ = normalizedZ * 2.0 * 2.0037508342789244E7 - 2.0037508342789244E7;
        double lat = Math.toDegrees(Math.atan(Math.sinh(mercatorZ / 6378137.0)));
        return new double[]{lon, lat};
    }

    public static double truncate(double num, int places) {
        return (double)((int)(num * Math.pow(10.0, places))) / Math.pow(10.0, places);
    }

    public static long pack(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    public static short[][] getSubArraySystemCopy(short[][] source, int x1, int y1, int x2, int y2) {
        int width = x2 - x1;
        int height = y2 - y1;
        short[][] result = new short[height][width];
        for (int i = 0; i < height; ++i) {
            System.arraycopy(source[y1 + i], x1, result[i], 0, width);
        }
        return result;
    }
}

