/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.world.gen;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.Util;

public class BiomeProvider {
    private static final String CACHE_DIR = "/biomes/";
    private static final Logger LOGGER = Terrarium.LOGGER;
    private static final Map<Long, int[][]> biomeMap = new ConcurrentHashMap<Long, int[][]>();
    private static final int QUALITY = 7;

    private static BufferedImage getClimateFromHeightmap(int xTile, int zTile, Path cachePath, URI path) {
        BufferedImage bufferedImage;
        block13: {
            URI uri = path.resolve("7/" + xTile + "/" + zTile + ".png");
            File cacheFile = cachePath.resolve("7/" + xTile + "/" + zTile + ".png").toFile();
            if (cacheFile.exists()) {
                try {
                    return ImageIO.read(cacheFile);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load tile from cache: {}", (Object)e.getMessage());
                }
            }
            InputStream inputStream = uri.toURL().openStream();
            try {
                BufferedImage tileImage = ImageIO.read(inputStream);
                if (tileImage == null) {
                    throw new IOException("Failed to read image from URL: " + String.valueOf(uri));
                }
                Path cacheDir = Paths.get(cacheFile.getParent(), new String[0]);
                if (!Files.exists(cacheDir, new LinkOption[0])) {
                    Files.createDirectories(cacheDir, new FileAttribute[0]);
                }
                ImageIO.write((RenderedImage)tileImage, "png", cacheFile);
                bufferedImage = tileImage;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to download tile: {}", (Object)e.getMessage());
                    return new BufferedImage(256, 256, 1);
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    private static int[][] toByteArr(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] arr = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                arr[y][x] = image.getRGB(x, y);
            }
        }
        return arr;
    }

    public static int getClimate(int x, int z) {
        if (biomeMap.size() > 16) {
            biomeMap.clear();
        }
        double scale = Math.pow(2.0, 7 - Terrarium.CONFIG.zoom);
        int scaledX = (int)((double)x * scale);
        int scaledZ = (int)((double)z * scale);
        int Xtile = scaledX >> 8;
        int Ztile = scaledZ >> 8;
        return biomeMap.computeIfAbsent(Util.pack(Xtile, Ztile), k -> BiomeProvider.toByteArr(BiomeProvider.getClimateFromHeightmap(Xtile, Ztile, Path.of(Terrarium.CONFIG1.CACHE_DIR + CACHE_DIR, new String[0]), Terrarium.CONFIG1.BIOME_URL)))[scaledX & 0xFF][scaledZ & 0xFF];
    }
}

