/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.world.gen;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.Util;

public class HeightProvider {
    private static final String ELEV_CACHE_DIR = "/elevation/";
    private static final String WATER_CACHE_DIR = "/water/";
    private static final Logger LOGGER = Terrarium.LOGGER;
    public static int size = (int)(256.0 * Math.pow(2.0, Terrarium.CONFIG.zoom));
    private static final Map<Long, short[][]> elevMap = new ConcurrentHashMap<Long, short[][]>();
    private static final Map<Long, short[][]> waterMap = new ConcurrentHashMap<Long, short[][]>();

    public static void init() {
        size = (int)(256.0 * Math.pow(2.0, Terrarium.CONFIG.zoom));
    }

    private static BufferedImage getElevationFromHeightmap(int xTile, int zTile, Path cachePath, URI path) {
        BufferedImage bufferedImage;
        block13: {
            URI uri = path.resolve(Terrarium.CONFIG.zoom + "/" + xTile + "/" + zTile + ".png");
            File cacheFile = cachePath.resolve(Terrarium.CONFIG.zoom + "/" + xTile + "/" + zTile + ".png").toFile();
            if (cacheFile.exists()) {
                try {
                    return ImageIO.read(cacheFile);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load tile from cache: {}", (Object)e.getMessage());
                }
            }
            InputStream inputStream = uri.toURL().openStream();
            try {
                BufferedImage tileImage = ImageIO.read(inputStream);
                if (tileImage == null) {
                    throw new IOException("Failed to read image from URL: " + String.valueOf(uri));
                }
                Path cacheDir = Paths.get(cacheFile.getParent(), new String[0]);
                if (!Files.exists(cacheDir, new LinkOption[0])) {
                    Files.createDirectories(cacheDir, new FileAttribute[0]);
                }
                ImageIO.write((RenderedImage)tileImage, "png", cacheFile);
                bufferedImage = tileImage;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to download tile: {}", (Object)e.getMessage());
                    return new BufferedImage(256, 256, 1);
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    private static short[][] toIntHeightmap(BufferedImage image) {
        short[][] arr = new short[image.getWidth()][image.getHeight()];
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int rgb = image.getRGB(i, j);
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                double elevation = (double)(red * 256 + green) + (double)blue / 256.0 - 32768.0;
                arr[i][j] = (short)(elevation / 8850.0 * (double)Terrarium.CONFIG.worldHeight);
            }
        }
        return arr;
    }

    public static short getElevation(int x, int z) {
        return elevMap.computeIfAbsent(Util.pack(x >> 8, z >> 8), k -> HeightProvider.toIntHeightmap(HeightProvider.getElevationFromHeightmap(x >> 8, z >> 8, Path.of(Terrarium.CONFIG1.CACHE_DIR + ELEV_CACHE_DIR, new String[0]), Terrarium.CONFIG1.ELEVATION_URL)))[x & 0xFF][z & 0xFF];
    }

    public static short getWaterElevation(int x, int z) {
        return waterMap.computeIfAbsent(Util.pack(x >> 8, z >> 8), k -> HeightProvider.toIntHeightmap(HeightProvider.getElevationFromHeightmap(x >> 8, z >> 8, Path.of(Terrarium.CONFIG1.CACHE_DIR + WATER_CACHE_DIR, new String[0]), Terrarium.CONFIG1.WATER_URL)))[x & 0xFF][z & 0xFF];
    }
}

