/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.world.gen.biome;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import xyz.lynxs.terrarium.Terrarium;

public class BiomeColorRegistry {
    private static final Map<class_6862<class_1959>, BiomeColorMapping> TAG_TO_MAPPING = new ConcurrentHashMap<class_6862<class_1959>, BiomeColorMapping>();
    private static final Map<Integer, class_6862<class_1959>> COLOR_TO_TAG = new ConcurrentHashMap<Integer, class_6862<class_1959>>();
    private static MinecraftServer biomeRegistry;
    private static class_2960 defaultBiomeId;

    private static int parseHexColor(String hex) {
        return Color.decode(hex).getRGB();
    }

    public static void load(class_3300 manager, MinecraftServer world) {
        TAG_TO_MAPPING.clear();
        COLOR_TO_TAG.clear();
        biomeRegistry = world;
        manager.method_14488("worldgen/biome_colors", id -> id.method_12832().endsWith("json")).forEach((id, resource) -> {
            try (InputStream input = resource.method_14482();){
                DataResult json = BiomeColorConfig.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new InputStreamReader(input)));
                BiomeColorConfig config = (BiomeColorConfig)((Pair)json.getOrThrow()).getFirst();
                for (BiomeColorMapping mapping : config.mappings()) {
                    TAG_TO_MAPPING.put(mapping.getBiomeTag(), mapping);
                    COLOR_TO_TAG.put(mapping.color(), mapping.getBiomeTag());
                }
                config.defaultBiome().ifPresent(defaultId -> {
                    defaultBiomeId = class_2960.method_60654((String)defaultId);
                });
            }
            catch (Exception e) {
                Terrarium.LOGGER.error("Failed to load biome color config: " + String.valueOf(id), (Throwable)e);
            }
        });
    }

    public static BiomeColorMapping getMappingForTag(class_6862<class_1959> tag) {
        return Optional.of(TAG_TO_MAPPING.get(tag)).orElse(null);
    }

    public static class_6862<class_1959> getTagForColor(int rgb) {
        return COLOR_TO_TAG.getOrDefault(rgb, (class_6862<class_1959>)class_6908.field_36514);
    }

    public static class_6885<class_1959> getBiomesForTag(class_6862<class_1959> tag) {
        return biomeRegistry.method_58576().method_58294().method_46751(class_7924.field_41236).method_46735(tag);
    }

    public static class_6880<class_1959> getDefaultBiome() {
        return biomeRegistry.method_58576().method_58294().method_46751(class_7924.field_41236).method_46747(class_1972.field_9451);
    }

    public static Collection<class_6862<class_1959>> getAllColorTags() {
        return Collections.unmodifiableSet(TAG_TO_MAPPING.keySet());
    }

    static {
        defaultBiomeId = class_1972.field_9451.method_29177();
    }

    public record BiomeColorMapping(class_2960 tagId, int color, Optional<String> comment) {
        public static final Codec<BiomeColorMapping> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("tag").forGetter(BiomeColorMapping::tagId), (App)Codec.STRING.fieldOf("color").xmap(BiomeColorRegistry::parseHexColor, color -> String.format("#%06X", color)).forGetter(BiomeColorMapping::color), (App)Codec.STRING.optionalFieldOf("comment").forGetter(BiomeColorMapping::comment)).apply((Applicative)instance, BiomeColorMapping::new));

        public class_6862<class_1959> getBiomeTag() {
            return class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)this.tagId);
        }
    }

    public record BiomeColorConfig(List<BiomeColorMapping> mappings, Optional<String> defaultBiome) {
        public static final Codec<BiomeColorConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeColorMapping.CODEC.listOf().fieldOf("mappings").forGetter(BiomeColorConfig::mappings), (App)Codec.STRING.optionalFieldOf("default_biome").forGetter(BiomeColorConfig::defaultBiome)).apply((Applicative)instance, BiomeColorConfig::new));
    }
}

