/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.world.gen.biome;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_3756;
import net.minecraft.class_4766;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_8197;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.world.gen.BiomeProvider;
import xyz.lynxs.terrarium.world.gen.HeightProvider;
import xyz.lynxs.terrarium.world.gen.biome.BiomeColorRegistry;

public class TerrariumBiomeSource
extends class_1966 {
    private static final MapCodec<class_6880<class_1959>> BIOME_CODEC = class_1959.field_24677.fieldOf("biome");
    public static final MapCodec<class_6544.class_6547<class_6880<class_1959>>> CUSTOM_CODEC = class_6544.class_6547.method_49497(BIOME_CODEC).fieldOf("biomes");
    private static final MapCodec<class_6880<class_8197>> PRESET_CODEC = class_8197.field_42987.fieldOf("preset").withLifecycle(Lifecycle.stable());
    public static final MapCodec<TerrariumBiomeSource> CODEC = Codec.mapEither(CUSTOM_CODEC, PRESET_CODEC).xmap(TerrariumBiomeSource::new, source -> source.biomeEntries);
    private final Either<class_6544.class_6547<class_6880<class_1959>>, class_6880<class_8197>> biomeEntries;
    private final class_3756 sampler;

    public TerrariumBiomeSource(Either<class_6544.class_6547<class_6880<class_1959>>, class_6880<class_8197>> biomeRegistry) {
        this.biomeEntries = biomeRegistry;
        this.sampler = new class_3756(class_5819.method_43047());
    }

    private class_6544.class_6547<class_6880<class_1959>> getBiomeRegistry() {
        return (class_6544.class_6547)this.biomeEntries.map(entries -> entries, parameterListEntry -> ((class_8197)parameterListEntry.comp_349()).method_49507());
    }

    protected MapCodec<? extends class_1966> method_28442() {
        return class_4766.field_24719;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return this.getBiomeRegistry().method_38128().stream().map(Pair::getSecond);
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 noise) {
        int adjustedX = x + Terrarium.CONFIG.adjustXoffset;
        int adjustedZ = z + Terrarium.CONFIG.adjustZoffset;
        int elevation = HeightProvider.getElevation(adjustedX, adjustedZ) + Terrarium.CONFIG.startingY;
        int climate = BiomeProvider.getClimate(adjustedX, adjustedZ);
        class_6862<class_1959> biomeTag = BiomeColorRegistry.getTagForColor(climate);
        class_6885<class_1959> biomes = elevation > 64 ? BiomeColorRegistry.getBiomesForTag(biomeTag) : BiomeColorRegistry.getBiomesForTag((class_6862<class_1959>)class_6908.field_36509);
        double noiseVal = Math.abs(this.sampler.method_33658((double)x / (double)biomes.method_40247() * Terrarium.CONFIG.noise_biome_scale, (double)y * 0.01, (double)z / (double)biomes.method_40247() * Terrarium.CONFIG.noise_biome_scale));
        return biomes.method_40240((int)(noiseVal * (double)biomes.method_40247()));
    }

    public void method_38114(List<String> info, class_2338 pos, class_6544.class_6552 noiseSampler) {
        int i = class_5742.method_33100((int)pos.method_10263());
        int k = class_5742.method_33100((int)pos.method_10260());
        int adjustedZ = k + Terrarium.CONFIG.adjustZoffset;
        int adjustedX = i + Terrarium.CONFIG.adjustXoffset;
        int climate = BiomeProvider.getClimate(adjustedX, adjustedZ);
        info.add("Biome builder PV: Biome: " + BiomeColorRegistry.getMappingForTag(BiomeColorRegistry.getTagForColor(climate)).comment().orElse("error"));
    }
}

