/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.world.gen.chunk;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2922;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5425;
import net.minecraft.class_5485;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5817;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5868;
import net.minecraft.class_5873;
import net.minecraft.class_6350;
import net.minecraft.class_6568;
import net.minecraft.class_6643;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6916;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.Util;
import xyz.lynxs.terrarium.accessor.TerrariumSurfaceBuilderAccessor;
import xyz.lynxs.terrarium.world.gen.HeightProvider;
import xyz.lynxs.terrarium.world.gen.biome.TerrariumBiomeSource;

public class TerrariumChunkGenerator
extends class_2794 {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private final class_6880<class_5284> settings;
    private final TerrariumBiomeSource biomeSource;
    public static final MapCodec<TerrariumChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TerrariumBiomeSource.CODEC.fieldOf("biome_source").forGetter(TerrariumChunkGenerator::getBiomeSource), (App)class_5284.field_24781.fieldOf("settings").forGetter(TerrariumChunkGenerator::getSettings)).apply((Applicative)instance, TerrariumChunkGenerator::new));

    public TerrariumChunkGenerator(TerrariumBiomeSource biomeSource, class_6880<class_5284> settings) {
        super((class_1966)biomeSource);
        this.biomeSource = biomeSource;
        this.settings = settings;
    }

    public int getFromMap(int x, int z) {
        int adjustedX = x + Terrarium.CONFIG.adjustXoffset;
        int adjustedZ = z + Terrarium.CONFIG.adjustZoffset;
        return HeightProvider.getElevation(adjustedX, adjustedZ) + Terrarium.CONFIG.startingY;
    }

    public class_6880<class_5284> getSettings() {
        return this.settings;
    }

    public TerrariumBiomeSource getBiomeSource() {
        return this.biomeSource;
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk2) {
        class_4543 biomeAccess2 = biomeAccess.method_38107((biomeX, biomeY, biomeZ) -> this.biomeSource.method_38109(biomeX, biomeY, biomeZ, noiseConfig.method_42371()));
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
        int i = 8;
        class_1923 chunkPos = chunk2.method_12004();
        class_6568 chunkNoiseSampler = chunk2.method_38255(chunk -> this.createChunkNoiseSampler((class_2791)chunk, structureAccessor, class_6748.method_39342((class_3233)chunkRegion), noiseConfig));
        class_6350 aquiferSampler = chunkNoiseSampler.method_38354();
        class_5873 carverContext = new class_5873(new class_3754((class_1966)this.biomeSource, this.settings), chunkRegion.method_30349(), chunk2.method_39460(), chunkNoiseSampler, noiseConfig, ((class_5284)this.settings.comp_349()).comp_478());
        class_6643 carvingMask = ((class_2839)chunk2).method_28510();
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                class_1923 chunkPos2 = new class_1923(chunkPos.field_9181 + j, chunkPos.field_9180 + k);
                class_2791 chunk22 = chunkRegion.method_8392(chunkPos2.field_9181, chunkPos2.field_9180);
                class_6880<class_1959> biome = this.biomeSource.method_38109(class_5742.method_33100((int)chunkPos2.method_8326()), 0, class_5742.method_33100((int)chunkPos2.method_8328()), noiseConfig.method_42371());
                class_5485 generationSettings = chunk22.method_44214(() -> this.method_44216(biome));
                Iterable iterable = generationSettings.method_30976();
                int l = 0;
                for (class_6880 registryEntry : iterable) {
                    class_2922 configuredCarver = (class_2922)registryEntry.comp_349();
                    chunkRandom.method_12663(seed + (long)l, chunkPos2.field_9181, chunkPos2.field_9180);
                    if (configuredCarver.method_12669((class_5819)chunkRandom)) {
                        configuredCarver.method_12668(carverContext, chunk2, arg_0 -> ((class_4543)biomeAccess2).method_22393(arg_0), (class_5819)chunkRandom, aquiferSampler, chunkPos2, carvingMask);
                    }
                    ++l;
                }
            }
        }
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
        if (class_155.method_37896((class_1923)chunk.method_12004())) {
            return;
        }
        class_5868 heightContext = new class_5868((class_2794)this, (class_5539)region);
        this.buildSurface(chunk, heightContext, noiseConfig, structures, region.method_22385(), (class_2378<class_1959>)region.method_30349().method_30530(class_7924.field_41236), class_6748.method_39342((class_3233)region));
    }

    @VisibleForTesting
    public void buildSurface(class_2791 chunk, class_5868 heightContext, class_7138 noiseConfig, class_5138 structureAccessor, class_4543 biomeAccess, class_2378<class_1959> biomeRegistry, class_6748 blender) {
        class_6568 chunkNoiseSampler = chunk.method_38255(chunk3 -> this.createChunkNoiseSampler((class_2791)chunk3, structureAccessor, blender, noiseConfig));
        class_5284 chunkGeneratorSettings = (class_5284)this.settings.comp_349();
        ((TerrariumSurfaceBuilderAccessor)noiseConfig.method_42372()).buildSurface(noiseConfig, biomeAccess, biomeRegistry, chunkGeneratorSettings.comp_483(), heightContext, chunk, chunkNoiseSampler, chunkGeneratorSettings.comp_478());
    }

    public void method_12107(class_3233 region) {
        class_1923 chunkPos = region.method_33561();
        class_6880 registryEntry = region.method_23753(chunkPos.method_8323().method_33096(region.method_31600() - 1));
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(class_6673.method_39001()));
        chunkRandom.method_12661(region.method_8412(), chunkPos.method_8326(), chunkPos.method_8328());
        class_1948.method_8661((class_5425)region, (class_6880)registryEntry, (class_1923)chunkPos, (class_5819)chunkRandom);
    }

    public int method_12104() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_174();
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        class_5309 generationShapeConfig = ((class_5284)this.settings.comp_349()).comp_474().method_42368(chunk.method_39460());
        int k = class_3532.method_48116((int)generationShapeConfig.comp_174(), (int)generationShapeConfig.comp_179());
        if (k <= 0) {
            return CompletableFuture.completedFuture(chunk);
        }
        int x = (chunk.method_12004().field_9181 << 4) + Terrarium.CONFIG.adjustXoffset;
        int z = (chunk.method_12004().field_9180 << 4) + Terrarium.CONFIG.adjustZoffset;
        if (x < -16 || z < -16) {
            return CompletableFuture.completedFuture(chunk);
        }
        return CompletableFuture.supplyAsync(class_156.method_41238(() -> this.populateNoise(chunk), () -> "terrarium_cgen"), (Executor)class_156.method_18349());
    }

    private class_2791 populateNoise(class_2791 chunk) {
        class_2902 oceanHeightmap = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightmap = chunk.method_12032(class_2902.class_2903.field_13194);
        class_1923 chunkPos = chunk.method_12004();
        int i = chunkPos.method_8326();
        int j = chunkPos.method_8328();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680 defaultFluid = ((class_5284)this.settings.comp_349()).comp_476();
        for (int ii = 0; ii < 16; ++ii) {
            for (int jj = 0; jj < 16; ++jj) {
                int seaLevel = this.getSeaLevel(i + ii, j + jj);
                int elevation = this.getFromMap(i + ii, j + jj);
                for (int yy = ((class_5284)this.settings.comp_349()).comp_474().comp_173(); yy < ((class_5284)this.settings.comp_349()).comp_474().comp_174(); ++yy) {
                    mutable.method_10103(i + ii, yy, j + jj);
                    class_2680 state = yy <= seaLevel && yy >= elevation ? defaultFluid : (yy < elevation ? ((class_5284)this.settings.comp_349()).comp_475() : AIR);
                    chunk.method_12010((class_2338)mutable, state, false);
                    surfaceHeightmap.method_12597(i + ii & 0xF, yy, j + jj & 0xF, state);
                    oceanHeightmap.method_12597(i + ii & 0xF, yy, j + jj & 0xF, state);
                    mutable.method_10103(i + ii, yy, j + jj);
                    chunk.method_12039((class_2338)mutable);
                }
            }
        }
        return chunk;
    }

    public int method_16398() {
        return ((class_5284)this.settings.comp_349()).comp_479();
    }

    public int getSeaLevel(int x, int z) {
        int adjustedX = x + Terrarium.CONFIG.adjustXoffset;
        int adjustedZ = z + Terrarium.CONFIG.adjustZoffset;
        return HeightProvider.getWaterElevation(adjustedX, adjustedZ);
    }

    public int method_33730() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_173();
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return this.getFromMap(x, z);
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        int elevation = this.getFromMap(x, z);
        int seaLevel = this.getSeaLevel(x, z);
        if (elevation < this.method_33730()) {
            return new class_4966(world.method_31607(), new class_2680[]{class_2246.field_10124.method_9564()});
        }
        if (elevation < seaLevel) {
            return new class_4966(((class_5284)this.settings.comp_349()).comp_474().comp_173(), (class_2680[])Stream.concat(Stream.generate(() -> ((class_5284)this.settings.comp_349()).comp_475()).limit(elevation - this.method_33730()), Stream.generate(() -> ((class_5284)this.settings.comp_349()).comp_476()).limit(seaLevel - elevation - this.method_33730())).toArray(class_2680[]::new));
        }
        return new class_4966(((class_5284)this.settings.comp_349()).comp_474().comp_173(), (class_2680[])Stream.generate(() -> ((class_5284)this.settings.comp_349()).comp_475()).limit(elevation - this.method_33730() + 1).toArray(class_2680[]::new));
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
        text.add("[Terrarium] Elevation: " + this.getFromMap(pos.method_10263(), pos.method_10260()));
        text.add("[Terrarium] [Lat, Lon]: " + Arrays.toString(Util.gridToLatLon(pos.method_10263() + Terrarium.CONFIG.adjustXoffset, pos.method_10260() + Terrarium.CONFIG.adjustZoffset, HeightProvider.size)));
    }

    private class_6568 createChunkNoiseSampler(class_2791 chunk, class_5138 world, class_6748 blender, class_7138 noiseConfig) {
        return class_6568.method_39543((class_2791)chunk, (class_7138)noiseConfig, (class_6916.class_7050)class_5817.method_42695((class_5138)world, (class_1923)chunk.method_12004()), (class_5284)((class_5284)this.settings.comp_349()), (x, y, z) -> new class_6350.class_6351(this.method_16398(), ((class_5284)this.settings.comp_349()).comp_476()), (class_6748)blender);
    }
}

