/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import java.nio.file.Path;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.lynxs.terrarium.ConfigManager;
import xyz.lynxs.terrarium.TerrariumConfig;
import xyz.lynxs.terrarium.Util;
import xyz.lynxs.terrarium.gen.BiomeProvider;
import xyz.lynxs.terrarium.gen.HeightProvider;
import xyz.lynxs.terrarium.preset.PresetConfig;

public final class Terrarium {
    public static final String MOD_ID = "terrarium";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"terrarium");
    public static PresetConfig CONFIG = new PresetConfig();
    public static TerrariumConfig CONFIG1 = ConfigManager.register(TerrariumConfig.class, Path.of("terrarium.json", new String[0]), newConfig -> {
        CONFIG1 = newConfig;
    });

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void onServerWorldLoad(MinecraftServer server) {
        CONFIG = (PresetConfig)TerrariumConfig.load(CONFIG.getClass(), server.method_27050(class_5218.field_24188).resolve("terrarium.json"), false);
        LOGGER.info("Terrarium World Loaded!");
    }

    public static void init() {
        CommandRegistrationEvent.EVENT.register((commandDispatcher, commandBuildContext, commandSelection) -> Terrarium.register((CommandDispatcher<class_2168>)commandDispatcher));
        LOGGER.info("Terrarium mod initialized");
        BiomeProvider.init();
        LifecycleEvent.SERVER_LEVEL_LOAD.register(k -> Terrarium.onServerWorldLoad(k.method_8503()));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ecoregion").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            if (source.method_9228() == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by a player"));
                return 0;
            }
            class_2338 pos = source.method_9228().method_24515();
            String region = String.valueOf(BiomeProvider.getClimate(pos.method_10263(), pos.method_10260()));
            source.method_9226(() -> class_2561.method_43470((String)("Current Region: " + region)), false);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"geotp").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"longitude", (ArgumentType)DoubleArgumentType.doubleArg((double)-180.0, (double)180.0)).then(class_2170.method_9244((String)"latitude", (ArgumentType)DoubleArgumentType.doubleArg((double)-90.0, (double)90.0)).executes(context -> Terrarium.teleportToCoordinates((class_2168)context.getSource(), DoubleArgumentType.getDouble((CommandContext)context, (String)"longitude"), DoubleArgumentType.getDouble((CommandContext)context, (String)"latitude"))))).executes(context -> {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing latitude argument. Usage: /geotp <longitude> <latitude>"));
            return 0;
        }))).executes(context -> {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Usage: /geotp <longitude> <latitude> - Teleports to geographic coordinates"));
            return 0;
        }));
    }

    private static int teleportToCoordinates(class_2168 source, double longitude, double latitude) {
        class_1297 class_12972;
        if (source == null || !((class_12972 = source.method_9228()) instanceof class_1657)) {
            if (source != null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Only players can use this command!"));
            }
            return 0;
        }
        class_1657 player = (class_1657)class_12972;
        try {
            int x = Util.lonToX(longitude, (int)(Math.pow(2.0, Terrarium.CONFIG.zoom) * 256.0)) - Terrarium.CONFIG.adjustXoffset;
            int z = Util.latToZ(latitude, (int)(Math.pow(2.0, Terrarium.CONFIG.zoom) * 256.0)) - Terrarium.CONFIG.adjustZoffset;
            int y = HeightProvider.getElevation(x, z) + Terrarium.CONFIG.startingY;
            if (y < source.method_9225().method_31607()) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Could not find a safe location to teleport to!"));
                return 0;
            }
            player.method_5859((double)x + 0.5, (double)(y += 65), (double)z + 0.5);
            int finalY = y;
            source.method_9226(() -> class_2561.method_43470((String)String.format("Teleported to %.6f\u00b0 longitude, %.6f\u00b0 latitude (Minecraft coordinates: %d, %d, %d)", longitude, latitude, x, finalY, z)), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("An error occurred during teleportation: " + e.getMessage())));
            return 0;
        }
    }
}

