/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gui;

import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_6382;
import xyz.lynxs.terrarium.Terrarium;
import xyz.lynxs.terrarium.TerrariumConfig;
import xyz.lynxs.terrarium.Util;
import xyz.lynxs.terrarium.gen.BiomeProvider;
import xyz.lynxs.terrarium.gen.HeightProvider;
import xyz.lynxs.terrarium.gui.Slider;
import xyz.lynxs.terrarium.gui.TerrariumScrollableWidget;
import xyz.lynxs.terrarium.preset.PresetConfig;

public class TerrariumCustomizeScreen
extends class_437 {
    private final class_525 parent;
    private class_4185 doneButton;
    private class_4185 cancelButton;
    private Slider zoomSlider;
    private Slider worldHeightSlider;
    private Slider xOffsetSlider;
    private Slider zOffsetSlider;
    private final PresetConfig config;
    private TerrariumScrollableWidget scrollWidget;

    public TerrariumCustomizeScreen(class_525 parent) {
        super((class_2561)class_2561.method_43471((String)"terrarium.text.config_title"));
        this.parent = parent;
        this.config = new PresetConfig();
    }

    protected void method_25426() {
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonPadding = 5;
        int panelWidth = this.field_22789;
        int panelHeight = this.field_22790 - 75;
        int contentHeight = this.field_22790;
        this.scrollWidget = new TerrariumScrollableWidget(this, this.field_22787, this.field_22789 / 2 - panelWidth / 2, 30, panelWidth, panelHeight, contentHeight){

            protected void method_47399(class_6382 narrationElementOutput) {
            }

            protected int method_44395() {
                return 0;
            }

            protected double method_44393() {
                return 10.0;
            }

            @Override
            protected void renderContents(class_332 context, int mouseX, int mouseY, float delta) {
                super.renderContents(context, mouseX, (int)((double)mouseY + this.getScrollAmount()), delta);
            }
        };
        this.method_37063((class_364)this.scrollWidget);
        this.bottomPanel(buttonWidth, buttonHeight, buttonPadding);
        this.Settings();
    }

    private void Settings() {
        int sliderPadding = 5;
        int sliderWidth = this.field_22789 - 2 * sliderPadding;
        int sliderHeight = 20;
        Objects.requireNonNull(this.field_22793);
        this.worldHeightSlider = new Slider(sliderPadding, 9 + sliderPadding * 2 + sliderHeight * 2, sliderWidth, sliderHeight, this.config.worldHeight, 4.0f, 4096.0f, (class_2561)class_2561.method_43471((String)"terrarium.text.slider.world_height"), Slider.Format.INT, (slider, value) -> {
            this.config.worldHeight = (int)slider.scaleValue(value);
            return value;
        });
        Objects.requireNonNull(this.field_22793);
        this.xOffsetSlider = new Slider(sliderPadding, 9 + sliderPadding * 4 + sliderHeight * 4, sliderWidth, sliderHeight, Util.xToLon(this.config.adjustXoffset, (int)(256.0 * Math.pow(2.0, this.config.zoom))), -180.0f, 180.0f, (class_2561)class_2561.method_43471((String)"terrarium.text.slider.x_offset"), Slider.Format.FLOAT, (slider, value) -> {
            this.config.adjustXoffset = Util.lonToX(slider.scaleValue(value), (int)(256.0 * Math.pow(2.0, this.config.zoom)));
            return value;
        });
        Objects.requireNonNull(this.field_22793);
        this.zOffsetSlider = new Slider(sliderPadding, 9 + sliderPadding * 5 + sliderHeight * 5, sliderWidth, sliderHeight, Util.zToLat(this.config.adjustZoffset, (int)(256.0 * Math.pow(2.0, this.config.zoom))), -82.0f, 82.0f, (class_2561)class_2561.method_43471((String)"terrarium.text.slider.z_offset"), Slider.Format.FLOAT, (slider, value) -> {
            this.config.adjustZoffset = Util.latToZ(slider.scaleValue(value), (int)(256.0 * Math.pow(2.0, this.config.zoom)));
            return value;
        });
        Objects.requireNonNull(this.field_22793);
        this.zoomSlider = new Slider(sliderPadding, 9 + sliderPadding + sliderHeight, sliderWidth, sliderHeight, this.config.zoom, 0.0f, 15.0f, (class_2561)class_2561.method_43471((String)"terrarium.text.slider.zoom"), Slider.Format.INT, (slider, value) -> {
            int newVal = (int)slider.scaleValue(value);
            this.config.adjustXoffset = (int)((double)this.config.adjustXoffset * Math.pow(2.0, this.config.zoom - newVal));
            this.config.adjustZoffset = (int)((double)this.config.adjustZoffset * Math.pow(2.0, this.config.zoom - newVal));
            this.config.zoom = newVal;
            this.worldHeightSlider.setSliderValue((float)(Math.pow(2.0, this.config.zoom) / 10.0));
            return value;
        });
        this.scrollWidget.addChild(this.zoomSlider);
        this.scrollWidget.addChild(this.worldHeightSlider);
        this.scrollWidget.addChild(this.xOffsetSlider);
        this.scrollWidget.addChild(this.zOffsetSlider);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
    }

    private void bottomPanel(int buttonWidth, int buttonHeight, int buttonPadding) {
        assert (this.field_22787 != null);
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, btn -> {
            Terrarium.CONFIG = this.config;
            TerrariumConfig.save(Terrarium.CONFIG, Path.of("./saves/" + this.parent.method_48657().method_49703() + "/terrarium.json", new String[0]), false);
            HeightProvider.init();
            BiomeProvider.init();
            Thread thread = new Thread(() -> {
                Terrarium.LOGGER.info("Preloading Initial Data...");
                HeightProvider.getElevation(0, 0);
                HeightProvider.getSteepness(0, 0);
                BiomeProvider.getTemperature(0, 0);
                BiomeProvider.getHumidity(0, 0);
            }, "terrarium_DATA_PRELOADING");
            thread.start();
            this.field_22787.method_1507((class_437)this.parent);
        }).method_46434(this.field_22789 / 2 - (buttonWidth + buttonPadding), this.field_22790 - (buttonPadding + buttonHeight), buttonWidth, buttonHeight).method_46431();
        this.cancelButton = class_4185.method_46430((class_2561)class_5244.field_24335, btn -> {
            Terrarium.CONFIG = new PresetConfig();
            this.field_22787.method_1507((class_437)this.parent);
        }).method_46434(this.field_22789 / 2 + buttonPadding, this.field_22790 - (buttonPadding + buttonHeight), buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)this.cancelButton);
    }
}

