/*
 * Decompiled with CFR 0.152.
 */
package xyz.lynxs.terrarium.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_7528;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public abstract class TerrariumScrollableWidget
extends class_7528 {
    private double scrollAmount;
    private boolean scrolling;
    private final int contentHeight;
    @Nullable
    private Runnable onScroll;
    private final List<class_339> childWidgets = new ArrayList<class_339>();

    public TerrariumScrollableWidget(class_310 client, int x, int y, int width, int height, int contentHeight) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.contentHeight = contentHeight;
    }

    public <T extends class_339> void addChild(T widget) {
        this.childWidgets.add(widget);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        context.method_51448().pushMatrix();
        context.method_51448().translate(0.0f, (float)(-this.scrollAmount), new Matrix3x2f());
        this.renderBackground(context, mouseX, mouseY, delta);
        this.renderContents(context, mouseX, mouseY, delta);
        context.method_51448().popMatrix();
        context.method_44380();
        this.renderScrollBar(context);
    }

    protected void renderBackground(class_332 context, int mouseX, int mouseY, float delta) {
    }

    protected void renderContents(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_51448().pushMatrix();
        context.method_51448().translate(0.0f, (float)(-this.scrollAmount), new Matrix3x2f());
        for (class_339 widget : this.childWidgets) {
            widget.method_25394(context, mouseX, (int)((double)mouseY + this.getScrollAmount()), delta);
        }
        context.method_51448().popMatrix();
    }

    protected void renderScrollBar(class_332 context) {
        int scrollBarWidth = 6;
        int scrollBarX = this.method_46426() + this.field_22758 - scrollBarWidth - 2;
        context.method_25294(scrollBarX, this.method_46427(), scrollBarX + scrollBarWidth, this.method_46427() + this.field_22759, -10461088);
        int thumbHeight = Math.max(30, (int)((float)this.field_22759 / (float)this.contentHeight * (float)this.field_22759));
        int thumbY = this.method_46427() + (int)(this.scrollAmount / (double)(this.contentHeight - this.field_22759) * (double)(this.field_22759 - thumbHeight));
        context.method_25294(scrollBarX, thumbY, scrollBarX + scrollBarWidth, thumbY + thumbHeight, -4144960);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22764 || !this.field_22763) {
            return false;
        }
        for (class_339 widget : this.childWidgets) {
            if (!widget.method_25402(mouseX, mouseY + 2.0 * this.getScrollAmount(), button)) continue;
            return true;
        }
        if (button == 0 && mouseX >= (double)(this.method_46426() + this.field_22758 - 6)) {
            this.scrolling = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.field_22764 || !this.field_22763) {
            return false;
        }
        for (class_339 widget : this.childWidgets) {
            if (!widget.method_25402(mouseX, mouseY + 2.0 * this.getScrollAmount(), button)) continue;
            return true;
        }
        if (this.scrolling) {
            double scrollableHeight = this.contentHeight - this.field_22759;
            double scrollDelta = deltaY / (double)this.field_22759 * scrollableHeight;
            this.method_44382(this.scrollAmount + scrollDelta);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.field_22764 || !this.field_22763) {
            return false;
        }
        this.method_44382(this.scrollAmount - verticalAmount * 20.0);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.method_25406(mouseX, mouseY + this.getScrollAmount(), button);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void method_44382(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)Math.max(0, this.contentHeight - this.field_22759));
        if (this.onScroll != null) {
            this.onScroll.run();
        }
    }

    public void setOnScroll(@Nullable Runnable onScroll) {
        this.onScroll = onScroll;
    }
}

