/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.blocks;

import com.polarite.buddingpolar.BuddingPolar;
import com.polarite.buddingpolar.BuddingPolarBlocks;
import com.polarite.buddingpolar.blocks.BlockCertusQuartzCluster;
import com.polarite.buddingpolar.config.BuddingPolarConfig;
import com.polarite.buddingpolar.integration.AE2Integration;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BlockBuddingCertusQuartz
extends Block {
    private static final ThreadLocal<EntityPlayer> harvesters = new ThreadLocal();

    public BlockBuddingCertusQuartz() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(1.5f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149663_c("budding_certus_quartz_block");
        this.func_149658_d("buddingpolar:budding_certus_quartz_block");
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(BuddingPolar.creativeTabs);
        this.func_149675_a(true);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (player == null) {
            return false;
        }
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem == null) {
            return false;
        }
        boolean hasPickaxe = heldItem.func_77973_b().getToolClasses(heldItem).contains("pickaxe");
        if (BuddingPolarConfig.isSilkTouchRequiredForBuddingBlocks()) {
            return hasPickaxe && EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        }
        return hasPickaxe;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, 10);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        world.func_147464_a(x, y, z, (Block)this, 10);
        int acceleratorCount = 0;
        int additionalAttempts = 0;
        try {
            Class.forName("com.polarite.buddingpolar.integration.AE2Integration");
            acceleratorCount = AE2Integration.countAdjacentAccelerators(world, x, y, z);
            additionalAttempts = AE2Integration.calculateAdditionalGrowthAttempts(acceleratorCount);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int totalAttempts = 1 + additionalAttempts;
        int growthChance = acceleratorCount > 0 ? BuddingPolarConfig.getGrowthChanceWithAccelerators() : BuddingPolarConfig.getGrowthChanceWithoutAccelerators();
        boolean didGrow = false;
        for (int attempt = 0; attempt < totalAttempts && !didGrow; ++attempt) {
            if (rand.nextInt(growthChance) != 0) continue;
            didGrow = this.attemptGrowth(world, x, y, z, rand);
        }
    }

    private boolean attemptGrowth(World world, int x, int y, int z, Random rand) {
        int facing = rand.nextInt(6);
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        switch (facing) {
            case 0: {
                offsetY = -1;
                break;
            }
            case 1: {
                offsetY = 1;
                break;
            }
            case 2: {
                offsetZ = -1;
                break;
            }
            case 3: {
                offsetZ = 1;
                break;
            }
            case 4: {
                offsetX = -1;
                break;
            }
            case 5: {
                offsetX = 1;
            }
        }
        int targetX = x + offsetX;
        int targetY = y + offsetY;
        int targetZ = z + offsetZ;
        Block targetBlock = world.func_147439_a(targetX, targetY, targetZ);
        int targetMeta = world.func_72805_g(targetX, targetY, targetZ);
        if (targetBlock instanceof BlockCertusQuartzCluster && targetMeta % 6 == facing) {
            if (targetBlock == BuddingPolarBlocks.small_certus_quartz_bud) {
                world.func_147465_d(targetX, targetY, targetZ, BuddingPolarBlocks.medium_certus_quartz_bud, facing, 3);
                return true;
            }
            if (targetBlock == BuddingPolarBlocks.medium_certus_quartz_bud) {
                world.func_147465_d(targetX, targetY, targetZ, BuddingPolarBlocks.large_certus_quartz_bud, facing, 3);
                return true;
            }
            if (targetBlock == BuddingPolarBlocks.large_certus_quartz_bud) {
                world.func_147465_d(targetX, targetY, targetZ, BuddingPolarBlocks.certus_quartz_cluster, facing, 3);
                return true;
            }
        } else if (this.canGrowIn(targetBlock)) {
            world.func_147465_d(targetX, targetY, targetZ, BuddingPolarBlocks.small_certus_quartz_bud, facing, 3);
            return true;
        }
        return false;
    }

    private boolean canGrowIn(Block block) {
        return block.func_149688_o() == Material.field_151579_a || block.func_149688_o() == Material.field_151586_h;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        harvesters.set(player);
        super.func_149681_a(world, x, y, z, meta, player);
        harvesters.remove();
    }

    private boolean harvestingWithPickaxe() {
        EntityPlayer harvester = harvesters.get();
        if (harvester == null) {
            return false;
        }
        ItemStack heldItem = harvester.func_71045_bC();
        if (heldItem == null) {
            return false;
        }
        return heldItem.func_77973_b().getToolClasses(heldItem).contains("pickaxe");
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int fortune) {
        if (!(world.field_72995_K || world.restoringBlockSnapshots || this.harvestingWithPickaxe())) {
            return;
        }
        super.func_149690_a(world, x, y, z, metadata, chance, fortune);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        harvesters.remove();
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this), 1, metadata);
        if (itemStack != null) {
            drops.add(itemStack);
        }
        return drops;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (this.harvestingWithPickaxe()) {
            return Item.func_150898_a((Block)this);
        }
        return null;
    }
}

