/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.blocks;

import com.polarite.buddingpolar.BuddingPolar;
import com.polarite.buddingpolar.BuddingPolarItems;
import com.polarite.buddingpolar.config.BuddingPolarConfig;
import com.polarite.buddingpolar.integration.AE2Integration;
import com.polarite.buddingpolar.renderer.RenderIDs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCertusQuartzCluster
extends Block {
    private final int type;
    private static final String[] STAGE_NAMES = new String[]{"small_certus_quartz_bud", "medium_certus_quartz_bud", "large_certus_quartz_bud", "certus_quartz_cluster"};
    private static final String[] TEXTURE_NAMES = new String[]{"small_certus_quartz_bud", "medium_certus_quartz_bud", "large_certus_quartz_bud", "certus_quartz_cluster"};
    private static final ThreadLocal<EntityPlayer> harvesters = new ThreadLocal();

    public BlockCertusQuartzCluster(int type) {
        super(Material.field_151592_s);
        this.func_149711_c(1.5f);
        this.func_149752_b(1.5f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149663_c(STAGE_NAMES[type]);
        this.func_149658_d("buddingpolar:" + TEXTURE_NAMES[type]);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149715_a(0.0625f + (float)type * 0.125f);
        this.func_149647_a(BuddingPolar.creativeTabs);
        this.type = type;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 1 + this.type * 3;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (!this.harvestingWithPickaxe()) {
            return null;
        }
        if (AE2Integration.hasAE2Items()) {
            return AE2Integration.ae2MultiMaterial;
        }
        return null;
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            boolean hasSilkTouch;
            if (!this.harvestingWithPickaxe()) {
                harvesters.remove();
                return;
            }
            EntityPlayer harvester = harvesters.get();
            boolean bl = hasSilkTouch = harvester != null && EnchantmentHelper.func_77502_d((EntityLivingBase)harvester);
            if (BuddingPolarConfig.isSilkTouchRequiredForClusters() && hasSilkTouch) {
                ItemStack clusterBlock = new ItemStack((Block)this, 1, metadata);
                float f = 0.7f;
                double dx = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double dy = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double dz = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, clusterBlock);
                entityItem.field_145804_b = 10;
                world.func_72838_d((Entity)entityItem);
            } else {
                ItemStack itemStack;
                int quantity = this.quantityDropped(metadata, fortune, world.field_73012_v);
                if (quantity > 0 && (itemStack = BuddingPolarItems.createItemStackForCluster(this.type, quantity)) != null) {
                    float f = 0.7f;
                    double dx = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double dy = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double dz = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, itemStack);
                    entityItem.field_145804_b = 10;
                    world.func_72838_d((Entity)entityItem);
                }
            }
            harvesters.remove();
        }
    }

    protected ItemStack func_149644_j(int metadata) {
        return new ItemStack((Block)this, 1, metadata);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ItemStack itemStack;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        harvesters.remove();
        int quantity = this.quantityDroppedForAutomation(metadata, fortune, world.field_73012_v);
        if (quantity > 0 && (itemStack = BuddingPolarItems.createItemStackForCluster(this.type, quantity)) != null) {
            drops.add(itemStack);
        }
        return drops;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    private int quantityDroppedForAutomation(int meta, int fortune, Random random) {
        int drop = this.quantityDroppedBase(random);
        if (this.type == 3 && fortune > 0 && random.nextInt(2 + fortune) == 0) {
            drop += fortune;
        }
        return drop;
    }

    private int quantityDroppedBase(Random random) {
        switch (this.type) {
            case 3: {
                return 4 + random.nextInt(3);
            }
            case 2: {
                return 2 + random.nextInt(2);
            }
            case 1: {
                return 1 + random.nextInt(2);
            }
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (player == null) {
            return false;
        }
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem == null) {
            return false;
        }
        boolean hasPickaxe = heldItem.func_77973_b().getToolClasses(heldItem).contains("pickaxe");
        return hasPickaxe;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        int drop = this.func_149745_a(random);
        if (this.type == 3 && fortune > 0 && random.nextInt(2 + fortune) == 0) {
            drop += fortune;
        }
        return drop;
    }

    public int func_149745_a(Random random) {
        if (!this.harvestingWithPickaxe()) {
            return 0;
        }
        switch (this.type) {
            case 3: {
                return 4 + random.nextInt(3);
            }
            case 2: {
                return 2 + random.nextInt(2);
            }
            case 1: {
                return 1 + random.nextInt(2);
            }
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        harvesters.set(player);
        super.func_149681_a(world, x, y, z, meta, player);
    }

    private boolean harvestingWithPickaxe() {
        EntityPlayer harvester = harvesters.get();
        if (harvester == null) {
            return false;
        }
        ItemStack heldItem = harvester.func_71045_bC();
        if (heldItem == null) {
            return false;
        }
        Set toolClasses = heldItem.func_77973_b().getToolClasses(heldItem);
        return toolClasses.contains("pickaxe");
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return side;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float height = 0.1875f + (float)this.type * 0.125f;
        float xzOffset = 0.375f - (float)this.type * 0.0625f;
        switch (meta % 6) {
            case 0: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)((float)(y + 1) - height), (double)((float)z + xzOffset), (double)((float)(x + 1) - xzOffset), (double)((float)y + 1.0f), (double)((float)(z + 1) - xzOffset));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)y, (double)((float)z + xzOffset), (double)((float)(x + 1) - xzOffset), (double)((float)y + height), (double)((float)(z + 1) - xzOffset));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)((float)y + xzOffset), (double)((float)(z + 1) - height), (double)((float)(x + 1) - xzOffset), (double)((float)(y + 1) - xzOffset), (double)((float)z + 1.0f));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)((float)y + xzOffset), (double)z, (double)((float)(x + 1) - xzOffset), (double)((float)(y + 1) - xzOffset), (double)((float)z + height));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)((float)(x + 1) - height), (double)((float)y + xzOffset), (double)((float)z + xzOffset), (double)((float)x + 1.0f), (double)((float)(y + 1) - xzOffset), (double)((float)(z + 1) - xzOffset));
            }
            case 5: {
                return AxisAlignedBB.func_72330_a((double)x, (double)((float)y + xzOffset), (double)((float)z + xzOffset), (double)((float)x + height), (double)((float)(y + 1) - xzOffset), (double)((float)(z + 1) - xzOffset));
            }
        }
        return null;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z);
        float height = 0.1875f + (float)this.type * 0.125f;
        float xzOffset = 0.375f - (float)this.type * 0.0625f;
        switch (meta % 6) {
            case 0: {
                this.func_149676_a(xzOffset, 1.0f - height, xzOffset, 1.0f - xzOffset, 1.0f, 1.0f - xzOffset);
                break;
            }
            case 1: {
                this.func_149676_a(xzOffset, 0.0f, xzOffset, 1.0f - xzOffset, height, 1.0f - xzOffset);
                break;
            }
            case 2: {
                this.func_149676_a(xzOffset, xzOffset, 1.0f - height, 1.0f - xzOffset, 1.0f - xzOffset, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(xzOffset, xzOffset, 0.0f, 1.0f - xzOffset, 1.0f - xzOffset, height);
                break;
            }
            case 4: {
                this.func_149676_a(1.0f - height, xzOffset, xzOffset, 1.0f, 1.0f - xzOffset, 1.0f - xzOffset);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, xzOffset, xzOffset, height, 1.0f - xzOffset, 1.0f - xzOffset);
            }
        }
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        this.checkAndDropBlock(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.func_149707_d(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        switch (side % 6) {
            case 0: {
                offsetY = 1;
                break;
            }
            case 1: {
                offsetY = -1;
                break;
            }
            case 2: {
                offsetZ = 1;
                break;
            }
            case 3: {
                offsetZ = -1;
                break;
            }
            case 4: {
                offsetX = 1;
                break;
            }
            case 5: {
                offsetX = -1;
            }
        }
        return world.func_147439_a(x + offsetX, y + offsetY, z + offsetZ).func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 1));
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderIDs.CERTUS_QUARTZ_CLUSTER;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

