/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.integration;

import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class AE2Integration {
    public static Block growthAccelerator;
    public static Item ae2MultiMaterial;
    public static final int PURE_CERTUS_QUARTZ_META = 10;
    public static final int CERTUS_QUARTZ_DUST_META = 2;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        try {
            growthAccelerator = GameRegistry.findBlock((String)"appliedenergistics2", (String)"tile.BlockQuartzGrowthAccelerator");
            ae2MultiMaterial = GameRegistry.findItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial");
            if (growthAccelerator != null) {
                // empty if block
            }
            if (ae2MultiMaterial == null) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ItemStack createPureCertusQuartzCrystal(int count) {
        if (ae2MultiMaterial == null) {
            return null;
        }
        ItemStack result = new ItemStack(ae2MultiMaterial, count, 10);
        return result;
    }

    public static ItemStack createCertusQuartzDust(int count) {
        if (ae2MultiMaterial == null) {
            return null;
        }
        ItemStack result = new ItemStack(ae2MultiMaterial, count, 2);
        return result;
    }

    public static ItemStack getCertusQuartzItemStackForStage(int stage, int count) {
        switch (stage) {
            case 3: {
                return AE2Integration.createPureCertusQuartzCrystal(count);
            }
            case 0: 
            case 1: 
            case 2: {
                return AE2Integration.createCertusQuartzDust(count);
            }
        }
        return null;
    }

    public static boolean hasAE2Items() {
        return ae2MultiMaterial != null;
    }

    public static boolean isGrowthAccelerator(Block block) {
        return growthAccelerator != null && block == growthAccelerator;
    }

    public static int countAdjacentAccelerators(World world, int x, int y, int z) {
        if (growthAccelerator == null) {
            return 0;
        }
        int count = 0;
        if (AE2Integration.isActiveGrowthAccelerator(world, x + 1, y, z)) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, x - 1, y, z)) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, x, y + 1, z)) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, x, y - 1, z)) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, x, y, z + 1)) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, x, y, z - 1)) {
            ++count;
        }
        return count;
    }

    private static boolean isActiveGrowthAccelerator(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != growthAccelerator) {
            return false;
        }
        try {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null) {
                return false;
            }
            Class<?> tileClass = tileEntity.getClass();
            Method isPoweredMethod = null;
            try {
                isPoweredMethod = tileClass.getMethod("isPowered", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return true;
            }
            Object result = isPoweredMethod.invoke((Object)tileEntity, new Object[0]);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int calculateAdditionalGrowthAttempts(int acceleratorCount) {
        return acceleratorCount;
    }
}

