/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.worldgen;

import com.polarite.buddingpolar.BuddingPolarBlocks;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;

public class MeteoriteWorldHandler {
    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        this.scanChunkForMeteorites(event.world, event.getChunk().field_76635_g, event.getChunk().field_76647_h);
    }

    private void scanChunkForMeteorites(World world, int chunkX, int chunkZ) {
        for (int x = chunkX * 16; x < (chunkX + 1) * 16; ++x) {
            for (int z = chunkZ * 16; z < (chunkZ + 1) * 16; ++z) {
                for (int y = 10; y < world.func_72940_L(); ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (!this.isSkyChest(block)) continue;
                    this.processMeteorite(world, x, y, z);
                }
            }
        }
    }

    private boolean isSkyChest(Block block) {
        if (block == null) {
            return false;
        }
        String blockName = block.getClass().getSimpleName();
        String registryName = block.func_149739_a();
        return blockName.contains("SkyChest") || registryName.contains("BlockSkyChest") || registryName.contains("skyChest");
    }

    private void processMeteorite(World world, int x, int y, int z) {
        Block belowBlock = world.func_147439_a(x, y - 1, z);
        if (belowBlock == BuddingPolarBlocks.budding_certus_quartz_block) {
            return;
        }
        if (!this.isNearSkyStone(world, x, y, z)) {
            return;
        }
        int targetY = this.findBestPlacementY(world, x, y, z);
        if (targetY > 0) {
            world.func_147465_d(x, targetY, z, BuddingPolarBlocks.budding_certus_quartz_block, 0, 3);
            System.out.println("[Budding Polar] Placed budding certus quartz block under meteorite sky chest at " + x + ", " + targetY + ", " + z);
        }
    }

    private boolean isNearSkyStone(World world, int x, int y, int z) {
        int skyStoneCount = 0;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    Block block = world.func_147439_a(x + dx, y + dy, z + dz);
                    String registryName = block.func_149739_a();
                    if (!registryName.contains("skystone") && !registryName.contains("SkyStone") || ++skyStoneCount < 3) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int findBestPlacementY(World world, int x, int y, int z) {
        for (int checkY = y - 1; checkY > 5; --checkY) {
            Block block = world.func_147439_a(x, checkY, z);
            if (block == Blocks.field_150350_a || block == Blocks.field_150355_j || block == Blocks.field_150353_l || block == Blocks.field_150358_i || block == Blocks.field_150356_k) continue;
            return checkY;
        }
        return -1;
    }
}

