/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar;

import com.polarite.buddingpolar.BuddingPolarBlocks;
import com.polarite.buddingpolar.BuddingPolarItems;
import com.polarite.buddingpolar.CommonProxy;
import com.polarite.buddingpolar.commands.CommandCertusQuartzDebug;
import com.polarite.buddingpolar.config.BuddingPolarConfig;
import com.polarite.buddingpolar.integration.AE2Integration;
import com.polarite.buddingpolar.sounds.BuddingPolarSounds;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="buddingpolar", version="1.0.5", name="Budding Polar", dependencies="required-after:appliedenergistics2", guiFactory="com.polarite.buddingpolar.gui.GuiFactoryBuddingPolar")
public class BuddingPolar {
    public static final String MODID = "buddingpolar";
    public static final String VERSION = "1.0.5";
    public static final String NAME = "Budding Polar";
    @SidedProxy(clientSide="com.polarite.buddingpolar.ClientProxy", serverSide="com.polarite.buddingpolar.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="buddingpolar")
    public static BuddingPolar instance;
    public static BuddingPolarConfig config;
    public static final CreativeTabs creativeTabs;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = new File(event.getModConfigurationDirectory(), "buddingpolar.cfg");
        Configuration configuration = new Configuration(configFile);
        config = new BuddingPolarConfig(configuration);
        MinecraftForge.EVENT_BUS.register(BuddingPolarSounds.class);
        BuddingPolarBlocks.init();
        BuddingPolarItems.init();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        try {
            Class.forName("appeng.api.AEApi");
            AE2Integration.init();
            BuddingPolarItems.postInit();
        }
        catch (ClassNotFoundException e) {
            System.err.println("[Budding Polar] Applied Energistics 2 not found! Budding Polar will not function properly.");
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCertusQuartzDebug());
    }

    public static String find(String name) {
        return "buddingpolar:" + name;
    }

    static {
        creativeTabs = new CreativeTabs(MODID){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return BuddingPolarItems.certus_quartz_crystal != null ? new ItemStack(BuddingPolarItems.certus_quartz_crystal) : new ItemStack(Items.field_151045_i);
            }
        };
    }
}

