/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.blocks;

import com.polarite.buddingpolar.BuddingPolar;
import com.polarite.buddingpolar.BuddingPolarBlocks;
import com.polarite.buddingpolar.blocks.BlockCertusQuartzCluster;
import com.polarite.buddingpolar.config.BuddingPolarConfig;
import com.polarite.buddingpolar.integration.AE2Integration;
import com.polarite.buddingpolar.sounds.BuddingPolarSounds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBuddingCertusQuartz
extends Block {
    public BlockBuddingCertusQuartz() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(1.5f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149663_c("budding_certus_quartz_block");
        this.setRegistryName("buddingpolar", "budding_certus_quartz_block");
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(BuddingPolar.creativeTabs);
        this.func_149675_a(true);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            return false;
        }
        boolean hasPickaxe = heldItem.func_77973_b().getToolClasses(heldItem).contains("pickaxe");
        if (!hasPickaxe) {
            return false;
        }
        boolean silkTouchRequired = BuddingPolarConfig.isSilkTouchRequiredForBuddingBlocks();
        if (silkTouchRequired) {
            boolean hasSilkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) > 0;
            return hasSilkTouch;
        }
        return true;
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, (Block)this, 10);
        BuddingPolarSounds.playSound(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BuddingPolarSounds.BUDDING_PLACE, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_175684_a(pos, (Block)this, 10);
        int acceleratorCount = 0;
        int additionalAttempts = 0;
        try {
            Class.forName("com.polarite.buddingpolar.integration.AE2Integration");
            acceleratorCount = AE2Integration.countAdjacentAccelerators(world, pos);
            additionalAttempts = AE2Integration.calculateAdditionalGrowthAttempts(acceleratorCount);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int totalAttempts = 1 + additionalAttempts;
        int growthChance = acceleratorCount > 0 ? BuddingPolarConfig.getGrowthChanceWithAccelerators() : BuddingPolarConfig.getGrowthChanceWithoutAccelerators();
        boolean didGrow = false;
        for (int attempt = 0; attempt < totalAttempts && !didGrow; ++attempt) {
            if (rand.nextInt(growthChance) != 0) continue;
            didGrow = this.attemptGrowth(world, pos, rand);
        }
        if (rand.nextInt(8) == 0) {
            BuddingPolarSounds.playShimmerSound(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
    }

    private boolean attemptGrowth(World world, BlockPos pos, Random rand) {
        int facing = rand.nextInt(6);
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        switch (facing) {
            case 0: {
                offsetY = -1;
                break;
            }
            case 1: {
                offsetY = 1;
                break;
            }
            case 2: {
                offsetZ = -1;
                break;
            }
            case 3: {
                offsetZ = 1;
                break;
            }
            case 4: {
                offsetX = -1;
                break;
            }
            case 5: {
                offsetX = 1;
            }
        }
        BlockPos targetPos = pos.func_177982_a(offsetX, offsetY, offsetZ);
        IBlockState targetState = world.func_180495_p(targetPos);
        Block targetBlock = targetState.func_177230_c();
        if (targetBlock instanceof BlockCertusQuartzCluster) {
            int targetMeta = targetBlock.func_176201_c(targetState);
            if (targetMeta % 6 == facing) {
                if (targetBlock == BuddingPolarBlocks.small_certus_quartz_bud) {
                    world.func_175656_a(targetPos, BuddingPolarBlocks.medium_certus_quartz_bud.func_176203_a(facing));
                    return true;
                }
                if (targetBlock == BuddingPolarBlocks.medium_certus_quartz_bud) {
                    world.func_175656_a(targetPos, BuddingPolarBlocks.large_certus_quartz_bud.func_176203_a(facing));
                    return true;
                }
                if (targetBlock == BuddingPolarBlocks.large_certus_quartz_bud) {
                    world.func_175656_a(targetPos, BuddingPolarBlocks.certus_quartz_cluster.func_176203_a(facing));
                    return true;
                }
            }
        } else if (this.canGrowIn(targetState)) {
            world.func_175656_a(targetPos, BuddingPolarBlocks.small_certus_quartz_bud.func_176203_a(facing));
            return true;
        }
        return false;
    }

    private boolean canGrowIn(IBlockState state) {
        return state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151586_h;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        BuddingPolarSounds.playSound(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BuddingPolarSounds.BUDDING_BREAK, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        BuddingPolarSounds.playSound(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BuddingPolarSounds.BUDDING_STEP, 0.7f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }
}

