/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.blocks;

import com.polarite.buddingpolar.BuddingPolar;
import com.polarite.buddingpolar.BuddingPolarItems;
import com.polarite.buddingpolar.config.BuddingPolarConfig;
import com.polarite.buddingpolar.sounds.BuddingPolarSounds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCertusQuartzCluster
extends Block {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    private final int type;
    private final String name;
    private static final ThreadLocal<EntityPlayer> harvestingPlayer = new ThreadLocal();
    private static final String[] STAGE_NAMES = new String[]{"small_certus_quartz_bud", "medium_certus_quartz_bud", "large_certus_quartz_bud", "certus_quartz_cluster"};

    public BlockCertusQuartzCluster(int type) {
        super(Material.field_151592_s);
        this.func_149711_c(1.5f);
        this.func_149752_b(1.5f);
        this.func_149672_a(SoundType.field_185853_f);
        this.name = STAGE_NAMES[type];
        this.func_149663_c(this.name);
        this.setRegistryName("buddingpolar", this.name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149715_a(this.getLightLevelForType(type));
        this.func_149713_g(0);
        this.func_149647_a(BuddingPolar.creativeTabs);
        this.type = type;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.UP));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getLightValueForType(this.type);
    }

    private float getLightLevelForType(int type) {
        switch (type) {
            case 0: {
                return 0.25f;
            }
            case 1: {
                return 0.4375f;
            }
            case 2: {
                return 0.625f;
            }
            case 3: {
                return 0.875f;
            }
        }
        return 0.25f;
    }

    private int getLightValueForType(int type) {
        switch (type) {
            case 0: {
                return 4;
            }
            case 1: {
                return 7;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 14;
            }
        }
        return 4;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack itemStack;
        int silkTouchLevel;
        ItemStack heldItem;
        EntityPlayer player;
        if (BuddingPolarConfig.isSilkTouchRequiredForClusters() && (player = harvestingPlayer.get()) != null && !(heldItem = player.func_184614_ca()).func_190926_b() && (silkTouchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem)) > 0) {
            drops.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(state)));
            return;
        }
        int quantity = this.quantityDroppedBase(world instanceof World ? ((World)world).field_73012_v : new Random());
        if (this.type == 3 && fortune > 0) {
            Random rand;
            Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            if (rand.nextInt(2 + fortune) == 0) {
                quantity += fortune;
            }
        }
        if (quantity > 0 && !(itemStack = BuddingPolarItems.createItemStackForCluster(this.type, quantity)).func_190926_b()) {
            drops.add((Object)itemStack);
        }
    }

    private int quantityDroppedBase(Random random) {
        switch (this.type) {
            case 3: {
                return 4 + random.nextInt(4);
            }
            case 2: {
                return 2 + random.nextInt(2);
            }
            case 1: {
                return 1 + random.nextInt(2);
            }
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            return false;
        }
        return heldItem.func_77973_b().getToolClasses(heldItem).contains("pickaxe");
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        harvestingPlayer.set(player);
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        harvestingPlayer.remove();
    }

    protected boolean func_149700_E() {
        return BuddingPolarConfig.isSilkTouchRequiredForClusters();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)facing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        float height = 0.1875f + (float)this.type * 0.125f;
        float xzOffset = 0.375f - (float)this.type * 0.0625f;
        switch (facing) {
            case DOWN: {
                return new AxisAlignedBB((double)xzOffset, (double)(1.0f - height), (double)xzOffset, (double)(1.0f - xzOffset), 1.0, (double)(1.0f - xzOffset));
            }
            case UP: {
                return new AxisAlignedBB((double)xzOffset, 0.0, (double)xzOffset, (double)(1.0f - xzOffset), (double)height, (double)(1.0f - xzOffset));
            }
            case NORTH: {
                return new AxisAlignedBB((double)xzOffset, (double)xzOffset, (double)(1.0f - height), (double)(1.0f - xzOffset), (double)(1.0f - xzOffset), 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)xzOffset, (double)xzOffset, 0.0, (double)(1.0f - xzOffset), (double)(1.0f - xzOffset), (double)height);
            }
            case WEST: {
                return new AxisAlignedBB((double)(1.0f - height), (double)xzOffset, (double)xzOffset, 1.0, (double)(1.0f - xzOffset), (double)(1.0f - xzOffset));
            }
            case EAST: {
                return new AxisAlignedBB(0.0, (double)xzOffset, (double)xzOffset, (double)height, (double)(1.0f - xzOffset), (double)(1.0f - xzOffset));
            }
        }
        return field_185505_j;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos, state)) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        BlockPos supportPos = pos.func_177972_a(facing.func_176734_d());
        IBlockState supportState = world.func_180495_p(supportPos);
        return supportState.isSideSolid((IBlockAccess)world, supportPos, facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos supportPos = pos.func_177972_a(side.func_176734_d());
        IBlockState supportState = world.func_180495_p(supportPos);
        return supportState.isSideSolid((IBlockAccess)world, supportPos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        BuddingPolarSounds.playSound(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BuddingPolarSounds.CLUSTER_BREAK, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        BuddingPolarSounds.playSound(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BuddingPolarSounds.CLUSTER_PLACE, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187902_gb, SoundCategory.BLOCKS, 0.3f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }
}

