/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.commands;

import com.polarite.buddingpolar.blocks.BlockBuddingCertusQuartz;
import com.polarite.buddingpolar.integration.AE2Integration;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class CommandCertusQuartzDebug
extends CommandBase {
    public String func_71517_b() {
        return "certusquartzdebug";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/certusquartzdebug - Shows growth info for the budding certus quartz block you're standing on";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("This command can only be used by players."));
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        World world = player.field_70170_p;
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockBuddingCertusQuartz)) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cYou are not standing on a Budding Certus Quartz block!"));
            return;
        }
        int acceleratorCount = 0;
        int inactiveAcceleratorCount = 0;
        int additionalAttempts = 0;
        try {
            Class.forName("com.polarite.buddingpolar.integration.AE2Integration");
            acceleratorCount = AE2Integration.countAdjacentAccelerators(world, pos);
            additionalAttempts = AE2Integration.calculateAdditionalGrowthAttempts(acceleratorCount);
            inactiveAcceleratorCount = this.countInactiveAccelerators(world, pos);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int totalAttempts = 1 + additionalAttempts;
        float growthChancePerAttempt = acceleratorCount > 0 ? 20.0f : 4.0f;
        double failureChancePerAttempt = 1.0 - (double)growthChancePerAttempt / 100.0;
        double overallFailureProbability = Math.pow(failureChancePerAttempt, totalAttempts);
        float overallGrowthChance = (float)((1.0 - overallFailureProbability) * 100.0);
        float averageTimeSeconds = 0.5f / (overallGrowthChance / 100.0f);
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7a=== Budding Certus Quartz Debug Info ==="));
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bPosition: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p()));
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bActive Growth Accelerators: \u00a7a" + acceleratorCount));
        if (inactiveAcceleratorCount > 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bInactive Growth Accelerators: \u00a7c" + inactiveAcceleratorCount + " \u00a77(not powered)"));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bTotal Growth Attempts: \u00a7e" + totalAttempts + " per update tick"));
        if (acceleratorCount > 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bChance Per Attempt: \u00a7e20.0% (1 in 5) \u00a7a[With Accelerators]"));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bChance Per Attempt: \u00a7e4.0% (1 in 25) \u00a7c[No Accelerators = 1/5th Speed]"));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bOverall Growth Chance: \u00a7e" + String.format("%.1f%%", Float.valueOf(overallGrowthChance)) + " per update tick"));
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7bAverage Time Per Stage: \u00a7e" + String.format("%.1f", Float.valueOf(averageTimeSeconds)) + " seconds"));
        if (acceleratorCount == 0 && inactiveAcceleratorCount == 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a77Tip: Place AE2 Growth Accelerators adjacent to this block for faster growth!"));
        } else if (acceleratorCount == 0 && inactiveAcceleratorCount > 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cYour Growth Accelerators need power! Connect them to an AE2 network."));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aOptimized with " + acceleratorCount + " active Growth Accelerator(s)!"));
        }
    }

    private int countInactiveAccelerators(World world, BlockPos pos) {
        int total = 0;
        int active = AE2Integration.countAdjacentAccelerators(world, pos);
        if (AE2Integration.isGrowthAccelerator(world.func_180495_p(pos.func_177974_f()).func_177230_c())) {
            ++total;
        }
        if (AE2Integration.isGrowthAccelerator(world.func_180495_p(pos.func_177976_e()).func_177230_c())) {
            ++total;
        }
        if (AE2Integration.isGrowthAccelerator(world.func_180495_p(pos.func_177984_a()).func_177230_c())) {
            ++total;
        }
        if (AE2Integration.isGrowthAccelerator(world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            ++total;
        }
        if (AE2Integration.isGrowthAccelerator(world.func_180495_p(pos.func_177978_c()).func_177230_c())) {
            ++total;
        }
        if (AE2Integration.isGrowthAccelerator(world.func_180495_p(pos.func_177968_d()).func_177230_c())) {
            ++total;
        }
        return total - active;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return Collections.emptyList();
    }
}

