/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.integration;

import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AE2Integration {
    public static Block growthAccelerator;
    public static Item ae2Material;
    public static Item certusQuartzCrystal;
    public static Item pureCertusQuartzCrystal;
    public static Item certusQuartzDust;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        try {
            Item it;
            growthAccelerator = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("appliedenergistics2", "quartz_growth_accelerator"));
            ae2Material = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", "material"));
            if (growthAccelerator == null) {
                String[] accelNames;
                for (String name : accelNames = new String[]{"quartz_growth_accelerator", "growth_accelerator", "growthaccelerator", "accelerator"}) {
                    Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("appliedenergistics2", name));
                    if (b == null) continue;
                    growthAccelerator = b;
                    break;
                }
            }
            if (ae2Material != null) {
                pureCertusQuartzCrystal = ae2Material;
                certusQuartzDust = ae2Material;
            } else {
                if (pureCertusQuartzCrystal == null) {
                    String[] pureNames = new String[]{"pure_certus_quartz_crystal", "certus_quartz_crystal_pure", "pure_certus_crystal", "pure_certus_quartz", "pure_certus_quartz_crystal"};
                    for (String name : pureNames) {
                        it = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", name));
                        if (it == null) continue;
                        pureCertusQuartzCrystal = it;
                        break;
                    }
                }
                if (certusQuartzDust == null) {
                    String[] dustNames = new String[]{"certus_quartz_dust", "certus_dust", "certusquartzdust"};
                    for (String name : dustNames) {
                        it = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", name));
                        if (it == null) continue;
                        certusQuartzDust = it;
                        break;
                    }
                }
            }
            if (certusQuartzCrystal == null) {
                String[] crystalNames = new String[]{"certus_quartz_crystal", "certus_crystal", "certus_quartz"};
                for (String name : crystalNames) {
                    it = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("appliedenergistics2", name));
                    if (it == null) continue;
                    certusQuartzCrystal = it;
                    break;
                }
            }
            if (growthAccelerator == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ItemStack createPureCertusQuartzCrystal(int count) {
        if (pureCertusQuartzCrystal == null) {
            return ItemStack.field_190927_a;
        }
        if (pureCertusQuartzCrystal == ae2Material && ae2Material != null) {
            return new ItemStack(ae2Material, count, 10);
        }
        return new ItemStack(pureCertusQuartzCrystal, count);
    }

    public static ItemStack createCertusQuartzDust(int count) {
        if (certusQuartzDust == null) {
            return ItemStack.field_190927_a;
        }
        if (certusQuartzDust == ae2Material && ae2Material != null) {
            return new ItemStack(ae2Material, count, 2);
        }
        return new ItemStack(certusQuartzDust, count);
    }

    public static ItemStack getCertusQuartzItemStackForStage(int stage, int count) {
        switch (stage) {
            case 3: {
                return AE2Integration.createPureCertusQuartzCrystal(count);
            }
            case 0: 
            case 1: 
            case 2: {
                return AE2Integration.createCertusQuartzDust(count);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasAE2Items() {
        return certusQuartzDust != null && pureCertusQuartzCrystal != null;
    }

    public static boolean isGrowthAccelerator(Block block) {
        return growthAccelerator != null && block == growthAccelerator;
    }

    public static int countAdjacentAccelerators(World world, BlockPos pos) {
        if (growthAccelerator == null) {
            return 0;
        }
        int count = 0;
        if (AE2Integration.isActiveGrowthAccelerator(world, pos.func_177974_f())) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, pos.func_177976_e())) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, pos.func_177984_a())) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, pos.func_177977_b())) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, pos.func_177978_c())) {
            ++count;
        }
        if (AE2Integration.isActiveGrowthAccelerator(world, pos.func_177968_d())) {
            ++count;
        }
        return count;
    }

    private static boolean isActiveGrowthAccelerator(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != growthAccelerator) {
            return false;
        }
        try {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity == null) {
                return false;
            }
            Class<?> tileClass = tileEntity.getClass();
            Method isPoweredMethod = null;
            try {
                isPoweredMethod = tileClass.getMethod("isPowered", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return true;
            }
            Object result = isPoweredMethod.invoke((Object)tileEntity, new Object[0]);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int calculateAdditionalGrowthAttempts(int acceleratorCount) {
        return acceleratorCount;
    }
}

