/*
 * Decompiled with CFR 0.152.
 */
package com.polarite.buddingpolar.sounds;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BuddingPolarSounds {
    public static SoundEvent BUDDING_BREAK;
    public static SoundEvent BUDDING_PLACE;
    public static SoundEvent BUDDING_STEP;
    public static SoundEvent BUDDING_SHIMMER;
    public static SoundEvent CLUSTER_BREAK;
    public static SoundEvent CLUSTER_PLACE;

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        BUDDING_BREAK = BuddingPolarSounds.registerSound((IForgeRegistry<SoundEvent>)registry, "budding_certus_break");
        BUDDING_PLACE = BuddingPolarSounds.registerSound((IForgeRegistry<SoundEvent>)registry, "budding_certus_place");
        BUDDING_STEP = BuddingPolarSounds.registerSound((IForgeRegistry<SoundEvent>)registry, "budding_certus_step");
        BUDDING_SHIMMER = BuddingPolarSounds.registerSound((IForgeRegistry<SoundEvent>)registry, "budding_certus_shimmer");
        CLUSTER_BREAK = BuddingPolarSounds.registerSound((IForgeRegistry<SoundEvent>)registry, "cluster_certus_break");
        CLUSTER_PLACE = BuddingPolarSounds.registerSound((IForgeRegistry<SoundEvent>)registry, "cluster_certus_place");
    }

    private static SoundEvent registerSound(IForgeRegistry<SoundEvent> registry, String name) {
        ResourceLocation location = new ResourceLocation("buddingpolar", name);
        SoundEvent event = new SoundEvent(location);
        event.setRegistryName(location);
        registry.register((IForgeRegistryEntry)event);
        return event;
    }

    public static void playSound(World world, double x, double y, double z, SoundEvent sound, float volume, float pitch) {
        if (!world.field_72995_K) {
            world.func_184148_a(null, x, y, z, sound, SoundCategory.BLOCKS, volume, pitch);
        }
    }

    public static void playShimmerSound(World world, double x, double y, double z) {
        BuddingPolarSounds.playSound(world, x, y, z, BUDDING_SHIMMER, 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }
}

