/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.axwarp;

import itzazeem.axwarp.commands.SetWarpCommand;
import itzazeem.axwarp.commands.WarpCommand;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public class Axwarp
extends JavaPlugin {
    private static Axwarp instance;
    private final Map<String, Location> warps = new HashMap<String, Location>();

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadWarps();
        this.getCommand("setwarp").setExecutor((CommandExecutor)new SetWarpCommand(this));
        this.getCommand("warp").setExecutor((CommandExecutor)new WarpCommand(this));
        this.getLogger().info("AxWarp enabled!");
    }

    public void onDisable() {
        this.saveWarps();
        this.getLogger().info("AxWarp disabled!");
    }

    public static Axwarp getInstance() {
        return instance;
    }

    public Map<String, Location> getWarps() {
        return this.warps;
    }

    public void saveWarps() {
        for (String name : this.warps.keySet()) {
            Location loc = this.warps.get(name);
            this.getConfig().set("warps." + name, (Object)loc);
        }
        this.saveConfig();
    }

    private void loadWarps() {
        if (this.getConfig().isConfigurationSection("warps")) {
            for (String name : this.getConfig().getConfigurationSection("warps").getKeys(false)) {
                Location loc = this.getConfig().getLocation("warps." + name);
                if (loc == null) continue;
                this.warps.put(name, loc);
            }
        }
    }
}

