/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.common.processing;

import com.google.common.collect.Maps;
import com.themastergeneral.enderfuge.Enderfuge;
import com.themastergeneral.enderfuge.common.config.Config;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class EnderfugeFuel {
    private static EnderfugeFuel SMELTING_BASE = new EnderfugeFuel();
    private final Map<ItemStack, Integer> fuelList = Maps.newHashMap();

    public static EnderfugeFuel instance() {
        return SMELTING_BASE;
    }

    private EnderfugeFuel() {
        this.addEnderfugeFuel(new ItemStack(Items.field_151061_bv), Config.eyeFuelTime);
        this.addEnderfugeFuel(new ItemStack(Items.field_151079_bi), Config.pearlFuelTime);
        this.addEnderfugeFuel(new ItemStack(Items.field_185158_cP), Config.crystalFuelTime);
        this.addEnderfugeFuel(new ItemStack(Items.field_190930_cZ), Config.shulkerShellFuelTime);
        this.addEnderfugeFuel(new ItemStack(Blocks.field_150380_bt), Config.dragonEggFuelTime);
        if (Config.creativeFuelItems) {
            this.loadCreativeItems();
        }
    }

    private void loadCreativeItems() {
        this.addEnderfugeFuel(new ItemStack(Blocks.field_150357_h), 9999999);
        this.addEnderfugeFuel(new ItemStack(Blocks.field_150483_bI), 9999999);
        this.addEnderfugeFuel(new ItemStack(Blocks.field_185776_dc), 9999999);
        this.addEnderfugeFuel(new ItemStack(Blocks.field_185777_dd), 9999999);
        this.addEnderfugeFuel(new ItemStack(Items.field_151095_cc), 9999999);
    }

    public void addEnderfugeFuel(ItemStack input, int burntime) {
        this.addFuel(input, burntime);
    }

    public void addFuel(ItemStack input, int burntime) {
        if (this.getFuelResult(input) != 0) {
            Enderfuge.logger.info("Ignored Enderfuge fuel with conflicting input: " + input + ".");
            return;
        }
        this.fuelList.put(input, burntime);
    }

    public void removeFuel(ItemStack input) {
        if (this.getFuelResult(input) == 0) {
            Enderfuge.logger.error("Attempted to remove Enderfuge fuel that isn't registered: " + input + ".");
            return;
        }
        this.fuelList.remove(input);
    }

    public Integer getFuelResult(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : this.fuelList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return 0;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, Integer> getSmeltingList() {
        return this.fuelList;
    }
}

