/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.common.processing;

import com.google.common.collect.Maps;
import com.themastergeneral.enderfuge.Enderfuge;
import com.themastergeneral.enderfuge.common.blocks.ModBlocks;
import com.themastergeneral.enderfuge.common.items.ModItems;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EnderfugeRecipes {
    private static EnderfugeRecipes SMELTING_BASE = new EnderfugeRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static EnderfugeRecipes instance() {
        return SMELTING_BASE;
    }

    private EnderfugeRecipes() {
        this.addSmeltingRecipe(new ItemStack(Blocks.field_150352_o, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 12), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Blocks.field_150366_p, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 12), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Blocks.field_150482_ag, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 12), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Blocks.field_150351_n, 8, Short.MAX_VALUE), new ItemStack(Items.field_151145_ak, 1), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Blocks.field_189877_df, 8, Short.MAX_VALUE), new ItemStack(Items.field_151065_br, 1), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Block)ModBlocks.enderfuge), new ItemStack((Block)ModBlocks.enderfuge_active), 0.0f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151006_E, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151005_D, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151010_B, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151013_M, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151011_C, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 4), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151169_ag, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 27), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151171_ah, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 40), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151149_ai, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 36), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151151_aj, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 22), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151136_bY, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 15), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151036_c, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151035_b, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151040_l, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151019_K, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151037_a, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 4), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151028_Y, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 27), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151030_Z, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 40), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151165_aa, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 36), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151167_ab, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 22), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151138_bX, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 15), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151020_U, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 27), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151023_V, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 40), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151022_W, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 36), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151029_X, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 22), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151056_x, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151046_w, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151048_u, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151012_L, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151047_v, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 4), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151161_ac, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 27), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151163_ad, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 40), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151173_ae, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 36), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151175_af, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 22), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151125_bZ, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.nuggetdiamond, 15), 0.7f);
    }

    public void addSmelting(ItemStack input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(input, stack, experience);
    }

    public void removeSmelting(ItemStack input, ItemStack stack) {
        ItemStack result = this.getSmeltingResult(input);
        if (result != stack) {
            Enderfuge.logger.error("Could not remove " + input + " = " + stack + " recipe, as it does not exist in the Enderfuge registry.");
            return;
        }
        this.smeltingList.remove(input, stack);
        float xp = this.getSmeltingExperience(stack);
        if (xp != 0.0f) {
            this.experienceList.remove(stack, Float.valueOf(xp));
        }
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getSmeltingResult(input) != ItemStack.field_190927_a) {
            Enderfuge.logger.info("Ignored smelting recipe with conflicting input: " + input + " = " + stack);
            return;
        }
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

