/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.integration;

import com.themastergeneral.ctdcore.helpers.StackHelper;
import com.themastergeneral.enderfuge.Enderfuge;
import com.themastergeneral.enderfuge.common.config.Config;
import com.themastergeneral.enderfuge.common.processing.EnderfugeFuel;
import com.themastergeneral.enderfuge.common.processing.EnderfugeRecipes;
import com.themastergeneral.enderfuge.integration.EU2Integration;
import com.themastergeneral.enderfuge.integration.IC2Integration;
import com.themastergeneral.enderfuge.integration.PSLIntegration;
import com.themastergeneral.enderfuge.integration.TFIntegration;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class Integration {
    public static void loadIntegration() {
        Integration.loadIC2();
        Integration.loadTF();
        Integration.loadEU2();
        Integration.loadPSL();
    }

    public static void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        EnderfugeRecipes.instance().addSmeltingRecipe(input, stack, experience);
    }

    public static void addEnderfugeFuel(ItemStack input, int burntime) {
        EnderfugeFuel.instance().addEnderfugeFuel(input, burntime);
    }

    public static void addRecipeByName(String name, String output, int qty, int meta, float xp) {
        Integration.addSmeltingRecipe(new ItemStack(StackHelper.itemFromRegistryName((String)name), 1, Short.MAX_VALUE), new ItemStack(StackHelper.itemFromRegistryName((String)output), qty, meta), xp);
    }

    public static void loadIC2() {
        if (Config.ic2compat && Loader.isModLoaded((String)"ic2")) {
            IC2Integration.loadRecipes();
            Enderfuge.logger.info("Loading IC2 integration.");
        } else {
            Enderfuge.logger.info("IC2 integration disabled, or IC2 not loaded.");
        }
    }

    public static void loadTF() {
        if (Config.tfcompat && Loader.isModLoaded((String)"thermalfoundation")) {
            TFIntegration.lead();
            Enderfuge.logger.info("Loading Thermal Foundation integration.");
        } else {
            Enderfuge.logger.info("Thermal Foundation integration disabled, or Thermal Foundation not loaded.");
        }
    }

    public static void loadEU2() {
        if (Config.eu2compat && Loader.isModLoaded((String)"extrautils2")) {
            EU2Integration.loadEU2();
            Enderfuge.logger.info("Loading Extra Utilities 2 integration.");
        } else {
            Enderfuge.logger.info("Extra Utilities 2 integration disabled, or Extra Utilities 2 not loaded.");
        }
    }

    public static void loadPSL() {
        if (Config.pslcompat && Loader.isModLoaded((String)"pumpkinspice")) {
            PSLIntegration.load();
            Enderfuge.logger.info("Loading Pumpkin Spice Latte integration.");
        } else {
            Enderfuge.logger.info("Pumpkin Spice Latte integration disabled, or Extra Utilities 2 not loaded.");
        }
    }
}

