/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.integration.jei;

import com.google.common.base.Preconditions;
import com.themastergeneral.enderfuge.common.config.Config;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EnderfugeFuelRecipe
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final String smeltCountString;
    private final String burnTimeString;
    private final IDrawableAnimated flame;
    ResourceLocation backgroundLocation = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");

    public EnderfugeFuelRecipe(IGuiHelper guiHelper, Collection<ItemStack> input, int burnTime) {
        Preconditions.checkArgument((burnTime > 0 ? 1 : 0) != 0, (Object)(" " + input + "'s burn time needs to be greater than 0."));
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(input);
        this.inputs = Collections.singletonList(inputList);
        if (burnTime == Config.smeltTime) {
            this.smeltCountString = "Smelts 1 Item";
        } else {
            NumberFormat numberInstance = NumberFormat.getNumberInstance();
            numberInstance.setMaximumFractionDigits(2);
            String smeltCount = numberInstance.format((float)burnTime / (float)Config.smeltTime);
            this.smeltCountString = "Smelts: " + smeltCount + " items.";
        }
        this.burnTimeString = "Burn: " + burnTime + " ticks.";
        IDrawableStatic flameDrawable = guiHelper.createDrawable(this.backgroundLocation, 82, 114, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, burnTime, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.flame.draw(minecraft, 1, 0);
        minecraft.field_71466_p.func_78276_b(this.smeltCountString, 24, 8, Color.black.getRGB());
        minecraft.field_71466_p.func_78276_b(this.burnTimeString, 24, 18, Color.black.getRGB());
    }
}

