/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.utils;

import com.themastergeneral.enderfuge.Enderfuge;
import com.themastergeneral.enderfuge.common.processing.EnderfugeFuel;
import com.themastergeneral.enderfuge.common.processing.EnderfugeRecipes;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCHandler {
    public static final IMCHandler INSTANCE = new IMCHandler();
    static final String INPUT = "input";
    static final String XP = "xp";
    static final String OUTPUT = "output";
    static final String BURNTIME = "burn";
    public static final String ADD_ENDERFUGE_RECIPE = "setRecipeEnderfuge";
    public static final String ADD_ENDERFUGE_FUEL = "setFuelEnderfuge";
    public static final String REMOVE_ENDERFUGE_RECIPE = "unsetRecipeEnderfuge";
    public static final String REMOVE_ENDERFUGE_FUEL = "unsetFuelEnderfuge";

    public void handleIMC(List<FMLInterModComms.IMCMessage> messages) {
        block14: for (FMLInterModComms.IMCMessage message : messages) {
            try {
                String operation;
                if (!message.isNBTMessage()) continue;
                NBTTagCompound nbt = message.getNBTValue();
                switch (operation = message.key.toLowerCase(Locale.US)) {
                    case "setRecipeEnderfuge": {
                        if (nbt.func_74764_b(XP)) {
                            EnderfugeRecipes.instance().addSmeltingRecipe(new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)), nbt.func_74760_g(XP));
                            continue block14;
                        }
                        EnderfugeRecipes.instance().addSmeltingRecipe(new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)), 0.0f);
                        continue block14;
                    }
                    case "setFuelEnderfuge": {
                        EnderfugeFuel.instance().addFuel(new ItemStack(nbt.func_74775_l(INPUT)), nbt.func_74762_e(BURNTIME));
                        continue block14;
                    }
                    case "unsetRecipeEnderfuge": {
                        EnderfugeRecipes.instance().removeSmelting(new ItemStack(nbt.func_74775_l(INPUT)), new ItemStack(nbt.func_74775_l(OUTPUT)));
                        continue block14;
                    }
                    case "unsetFuelEnderfuge": {
                        EnderfugeFuel.instance().removeFuel(new ItemStack(nbt.func_74775_l(INPUT)));
                        continue block14;
                    }
                }
                Enderfuge.logger.warn("Enderfuge received an invalid IMC from " + message.getSender() + "! Key was " + message.key);
            }
            catch (Exception e) {
                Enderfuge.logger.warn("Enderfuge received a broken IMC from " + message.getSender() + "!");
                e.printStackTrace();
            }
        }
    }
}

