/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.integration.jei;

import com.themastergeneral.enderfuge.integration.jei.EnderfugeRecipeCategory;
import com.themastergeneral.enderfuge.integration.jei.EnderfugeSmeltingRecipe;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EnderfugeSmeltingCategory
extends EnderfugeRecipeCategory<EnderfugeSmeltingRecipe> {
    private final IDrawable background;
    private final String localizedName;

    public EnderfugeSmeltingCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.background = guiHelper.createDrawable(location, 55, 16, 82, 54);
        this.localizedName = "Enderfuge";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 2, 20);
        this.arrow.draw(minecraft, 24, 18);
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getUid() {
        return "enderfuge:enderfuge";
    }

    public void setRecipe(IRecipeLayout recipeLayout, EnderfugeSmeltingRecipe recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        List<List<ItemStack>> inputs = recipeWrapper.getInputs();
        guiItemStacks.set(0, inputs.get(0));
        List<ItemStack> outputs = recipeWrapper.getOutputs();
        guiItemStacks.set(2, outputs.get(0));
    }

    public void setRecipe(IRecipeLayout recipeLayout, EnderfugeSmeltingRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }
}

