/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.common.processing;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class EnderfugeRecipes {
    private static final EnderfugeRecipes SMELTING_BASE = new EnderfugeRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static EnderfugeRecipes instance() {
        return SMELTING_BASE;
    }

    private EnderfugeRecipes() {
        this.addSmeltingRecipe(new ItemStack(Items.field_151006_E, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151005_D, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151010_B, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151013_M, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151011_C, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 4), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151169_ag, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 27), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151171_ah, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 40), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151149_ai, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 36), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151151_aj, 1, Short.MAX_VALUE), new ItemStack(Items.field_151074_bl, 22), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151036_c, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151035_b, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 18), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151040_l, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151019_K, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 13), 0.7f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151037_a, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 4), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151028_Y, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 27), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151030_Z, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 40), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151165_aa, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 36), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151167_ab, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 22), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151020_U, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 27), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151023_V, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 40), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151022_W, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 36), 0.7f);
        this.addSmeltingRecipe(new ItemStack((Item)Items.field_151029_X, 1, Short.MAX_VALUE), new ItemStack(Items.field_191525_da, 22), 0.7f);
    }

    public void addSmeltingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSmelting(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSmelting(Item input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getSmeltingResult(input) != ItemStack.field_190927_a) {
            FMLLog.info((String)("Ignored smelting recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

