/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.enderfuge.integration.jei;

import com.themastergeneral.enderfuge.common.processing.EnderfugeRecipes;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class EnderfugeSmeltingRecipe
extends BlankRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;

    public EnderfugeSmeltingRecipe(List<ItemStack> inputs, ItemStack output) {
        this.inputs = Collections.singletonList(inputs);
        this.output = output;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return Collections.singletonList(this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        EnderfugeRecipes furnaceRecipes = EnderfugeRecipes.instance();
        float experience = furnaceRecipes.getSmeltingExperience(this.output);
        if (experience > 0.0f) {
            String experienceString = "gui.jei.category.smelting.experience";
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(experienceString);
            fontRendererObj.func_78276_b(experienceString, recipeWidth - stringWidth, 0, Color.gray.getRGB());
        }
    }
}

