/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.PlayerConfig;
import ce.ajneb97.model.player.EventData;
import ce.ajneb97.model.player.PlayerData;
import ce.ajneb97.utils.OtherUtils;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;

public class PlayerConfigsManager {
    private ConditionalEvents plugin;

    public PlayerConfigsManager(ConditionalEvents plugin) {
        this.plugin = plugin;
    }

    public void configure() {
        this.createPlayersFolder();
        this.loadPlayerData();
    }

    public void createPlayersFolder() {
        try {
            File folder = new File(this.plugin.getDataFolder() + File.separator + "players");
            if (!folder.exists()) {
                folder.mkdirs();
            }
        }
        catch (SecurityException e) {
            Object folder = null;
        }
    }

    private PlayerConfig getPlayerConfig(String pathName) {
        PlayerConfig playerConfig = new PlayerConfig(pathName, this.plugin);
        playerConfig.registerPlayerConfig();
        return playerConfig;
    }

    public void loadPlayerData() {
        File[] listOfFiles;
        ArrayList<PlayerData> playerData = new ArrayList<PlayerData>();
        String path = this.plugin.getDataFolder() + File.separator + "players";
        File folder = new File(path);
        for (File file : listOfFiles = folder.listFiles()) {
            String pathName;
            String ext;
            if (!file.isFile() || !(ext = OtherUtils.getFileExtension(pathName = file.getName())).equals("yml")) continue;
            PlayerConfig config = new PlayerConfig(pathName, this.plugin);
            config.registerPlayerConfig();
            FileConfiguration players = config.getConfig();
            String name = players.getString("name");
            String uuid = config.getPath().replace(".yml", "");
            PlayerData p = new PlayerData(uuid, name);
            ArrayList<EventData> eventData = new ArrayList<EventData>();
            if (players.contains("events")) {
                for (String key : players.getConfigurationSection("events").getKeys(false)) {
                    boolean oneTime = players.getBoolean("events." + key + ".one_time");
                    long cooldown = players.getLong("events." + key + ".cooldown");
                    EventData event = new EventData(key, cooldown, oneTime);
                    eventData.add(event);
                }
            }
            p.setEventData(eventData);
            playerData.add(p);
        }
        this.plugin.getPlayerManager().setPlayerData(playerData);
    }

    public void savePlayer(PlayerData player) {
        String playerName = player.getName();
        PlayerConfig playerConfig = this.getPlayerConfig(player.getUuid() + ".yml");
        FileConfiguration players = playerConfig.getConfig();
        players.set("name", (Object)playerName);
        players.set("events", null);
        for (EventData event : player.getEventData()) {
            String path = "events." + event.getName();
            players.set(path + ".one_time", (Object)event.isOneTime());
            players.set(path + ".cooldown", (Object)event.getCooldown());
        }
        playerConfig.savePlayerConfig();
    }

    public void savePlayerData() {
        for (PlayerData player : this.plugin.getPlayerManager().getPlayerData()) {
            if (player.isModified()) {
                this.savePlayer(player);
            }
            player.setModified(false);
        }
    }
}

