/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.libs.armorequipevent;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.libs.armorequipevent.ArmorListener;
import ce.ajneb97.utils.ServerVersion;
import org.bukkit.inventory.ItemStack;

public enum ArmorType {
    HELMET(5),
    CHESTPLATE(6),
    LEGGINGS(7),
    BOOTS(8);

    private final int slot;

    private ArmorType(int slot) {
        this.slot = slot;
    }

    public static ArmorType matchType(ItemStack itemStack) {
        if (ArmorListener.isAirOrNull(itemStack)) {
            return null;
        }
        String type = itemStack.getType().name();
        ServerVersion serverVersion = ConditionalEvents.serverVersion;
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_13_R1) ? type.equals("CARVED_PUMPKIN") : type.equals("PUMPKIN")) {
            return HELMET;
        }
        if (type.endsWith("_HELMET") || type.startsWith("SKULL_") || type.endsWith("_HEAD") || type.endsWith("_SKULL")) {
            return HELMET;
        }
        if (type.endsWith("_CHESTPLATE") || type.equals("ELYTRA")) {
            return CHESTPLATE;
        }
        if (type.endsWith("_LEGGINGS")) {
            return LEGGINGS;
        }
        if (type.endsWith("_BOOTS")) {
            return BOOTS;
        }
        return null;
    }

    public int getSlot() {
        return this.slot;
    }
}

