/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97;

import ce.ajneb97.MainCommand;
import ce.ajneb97.api.ConditionalEventsAPI;
import ce.ajneb97.api.ExpansionCE;
import ce.ajneb97.configs.ConfigsManager;
import ce.ajneb97.libs.armorequipevent.ArmorListener;
import ce.ajneb97.libs.itemselectevent.ItemSelectListener;
import ce.ajneb97.libs.itemselectevent.ItemSelectListenerNew;
import ce.ajneb97.listeners.CustomEventListener;
import ce.ajneb97.listeners.ItemEventsListener;
import ce.ajneb97.listeners.OtherEventsListener;
import ce.ajneb97.listeners.PlayerEventsListener;
import ce.ajneb97.listeners.PlayerEventsListenerNew1_16;
import ce.ajneb97.listeners.PlayerEventsListenerNew1_9;
import ce.ajneb97.listeners.dependencies.CitizensListener;
import ce.ajneb97.listeners.dependencies.WGRegionEventsListener;
import ce.ajneb97.managers.APIManager;
import ce.ajneb97.managers.BungeeMessagingManager;
import ce.ajneb97.managers.DebugManager;
import ce.ajneb97.managers.DependencyManager;
import ce.ajneb97.managers.EventsManager;
import ce.ajneb97.managers.InterruptEventManager;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.managers.PlayerManager;
import ce.ajneb97.managers.SavedItemsManager;
import ce.ajneb97.managers.UpdateCheckerManager;
import ce.ajneb97.managers.VerifyManager;
import ce.ajneb97.managers.commandregister.CommandRegisterManager;
import ce.ajneb97.managers.dependencies.Metrics;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.internal.ConditionEvent;
import ce.ajneb97.model.internal.UpdateCheckerResult;
import ce.ajneb97.tasks.PlayerDataSaveTask;
import ce.ajneb97.utils.ServerVersion;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ConditionalEvents
extends JavaPlugin {
    PluginDescriptionFile pdfFile = this.getDescription();
    public String version = this.pdfFile.getVersion();
    public static ServerVersion serverVersion;
    public static String prefix;
    private EventsManager eventsManager;
    private DependencyManager dependencyManager;
    private PlayerManager playerManager;
    private ConfigsManager configsManager;
    private DebugManager debugManager;
    private BungeeMessagingManager bungeeMessagingManager;
    private MessagesManager messagesManager;
    private VerifyManager verifyManager;
    private UpdateCheckerManager updateCheckerManager;
    private CommandRegisterManager commandRegisterManager;
    private SavedItemsManager savedItemsManager;
    private APIManager apiManager;
    private InterruptEventManager interruptEventManager;
    private PlayerDataSaveTask playerDataSaveTask;

    public void onEnable() {
        this.setVersion();
        this.setPrefix();
        this.eventsManager = new EventsManager(this);
        this.dependencyManager = new DependencyManager(this);
        this.bungeeMessagingManager = new BungeeMessagingManager(this);
        this.debugManager = new DebugManager(this);
        this.playerManager = new PlayerManager(this);
        this.savedItemsManager = new SavedItemsManager(this);
        this.apiManager = new APIManager(this);
        this.interruptEventManager = new InterruptEventManager(this);
        this.configsManager = new ConfigsManager(this);
        this.configsManager.configure();
        this.registerEvents();
        this.registerCommands();
        this.verifyManager = new VerifyManager(this);
        this.verifyManager.verifyEvents();
        this.commandRegisterManager = new CommandRegisterManager(this);
        this.commandRegisterManager.registerCommands();
        this.reloadPlayerDataSaveTask();
        ConditionalEventsAPI api = new ConditionalEventsAPI(this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new ExpansionCE(this).register();
        }
        Metrics metrics = new Metrics(this, 19371);
        Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(prefix + " &eHas been enabled! &fVersion: " + this.version));
        Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(prefix + " &eThanks for using my plugin!   &f~Ajneb97"));
        this.updateCheckerManager = new UpdateCheckerManager(this.version);
        if (this.configsManager.getMainConfigManager().isUpdateNotifications()) {
            this.updateMessage(this.updateCheckerManager.check());
        }
        new ConditionEvent(this, null, null, EventType.SERVER_START, null).checkEvent();
    }

    public void onDisable() {
        new ConditionEvent(this, null, null, EventType.SERVER_STOP, null).checkEvent();
        this.configsManager.getPlayerConfigsManager().saveConfigs();
        Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(prefix + " &eHas been disabled! &fVersion: " + this.version));
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerEventsListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ItemEventsListener(this), (Plugin)this);
        pm.registerEvents((Listener)new ArmorListener(new ArrayList<String>()), (Plugin)this);
        pm.registerEvents((Listener)new ItemSelectListener(this), (Plugin)this);
        pm.registerEvents((Listener)new OtherEventsListener(this), (Plugin)this);
        pm.registerEvents((Listener)new CustomEventListener(this), (Plugin)this);
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_9_R1)) {
            pm.registerEvents((Listener)new ItemSelectListenerNew(), (Plugin)this);
            pm.registerEvents((Listener)new PlayerEventsListenerNew1_9(this), (Plugin)this);
        }
        if (serverVersion.serverVersionGreaterEqualThan(serverVersion, ServerVersion.v1_16_R1)) {
            pm.registerEvents((Listener)new PlayerEventsListenerNew1_16(this), (Plugin)this);
        }
        if (this.dependencyManager.isCitizens()) {
            pm.registerEvents((Listener)new CitizensListener(this), (Plugin)this);
        }
        if (this.dependencyManager.isWorldGuardEvents()) {
            pm.registerEvents((Listener)new WGRegionEventsListener(this), (Plugin)this);
        }
    }

    public void setPrefix() {
        prefix = MessagesManager.getColoredMessage("&4[&bConditionalEvents&4]");
    }

    public void setVersion() {
        String bukkitVersion;
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        switch (bukkitVersion = Bukkit.getServer().getBukkitVersion().split("-")[0]) {
            case "1.20.5": 
            case "1.20.6": {
                serverVersion = ServerVersion.v1_20_R4;
                break;
            }
            case "1.21": 
            case "1.21.1": {
                serverVersion = ServerVersion.v1_21_R1;
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                serverVersion = ServerVersion.v1_21_R2;
                break;
            }
            case "1.21.4": {
                serverVersion = ServerVersion.v1_21_R3;
                break;
            }
            case "1.21.5": {
                serverVersion = ServerVersion.v1_21_R4;
                break;
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                serverVersion = ServerVersion.v1_21_R5;
                break;
            }
            default: {
                try {
                    serverVersion = ServerVersion.valueOf(packageName.replace("org.bukkit.craftbukkit.", ""));
                    break;
                }
                catch (Exception e) {
                    serverVersion = ServerVersion.v1_21_R5;
                }
            }
        }
    }

    public void reloadEvents() {
        HandlerList.unregisterAll((Plugin)this);
        this.registerEvents();
    }

    public void reloadPlayerDataSaveTask() {
        if (this.playerDataSaveTask != null) {
            this.playerDataSaveTask.end();
        }
        this.playerDataSaveTask = new PlayerDataSaveTask(this);
        this.playerDataSaveTask.start(this.configsManager.getMainConfigManager().getConfig().getInt("Config.data_save_time"));
    }

    public void registerCommands() {
        this.getCommand("conditionalevents").setExecutor((CommandExecutor)new MainCommand(this));
    }

    public EventsManager getEventsManager() {
        return this.eventsManager;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public ConfigsManager getConfigsManager() {
        return this.configsManager;
    }

    public DebugManager getDebugManager() {
        return this.debugManager;
    }

    public BungeeMessagingManager getBungeeMessagingManager() {
        return this.bungeeMessagingManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public void setMessagesManager(MessagesManager messagesManager) {
        this.messagesManager = messagesManager;
    }

    public VerifyManager getVerifyManager() {
        return this.verifyManager;
    }

    public UpdateCheckerManager getUpdateCheckerManager() {
        return this.updateCheckerManager;
    }

    public CommandRegisterManager getCommandRegisterManager() {
        return this.commandRegisterManager;
    }

    public APIManager getApiManager() {
        return this.apiManager;
    }

    public SavedItemsManager getSavedItemsManager() {
        return this.savedItemsManager;
    }

    public InterruptEventManager getInterruptEventManager() {
        return this.interruptEventManager;
    }

    public void updateMessage(UpdateCheckerResult result) {
        if (!result.isError()) {
            String latestVersion = result.getLatestVersion();
            if (latestVersion != null) {
                Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cThere is a new version available. &e(&7" + latestVersion + "&e)"));
                Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage("&cYou can download it at: &fhttps://modrinth.com/plugin/conditionalevents"));
            }
        } else {
            Bukkit.getConsoleSender().sendMessage(MessagesManager.getColoredMessage(prefix + " &cError while checking update."));
        }
    }
}

