/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.model.CommonConfig;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.model.ToConditionGroup;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;

public class MainConfigManager {
    private CommonConfig configFile;
    private ConditionalEvents plugin;
    private boolean updateNotifications;
    private boolean debugActions;
    private boolean experimentalVariableReplacement;
    private boolean itemMetaVariableEnabled;
    private ArrayList<ToConditionGroup> toConditionGroups;

    public MainConfigManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.configFile = new CommonConfig("config.yml", plugin, null, false);
        this.configFile.registerConfig();
        this.checkMessagesUpdate();
    }

    public void configure() {
        FileConfiguration config = this.configFile.getConfig();
        this.updateNotifications = config.getBoolean("Config.update_notification");
        this.debugActions = config.getBoolean("Config.debug_actions");
        this.experimentalVariableReplacement = config.getBoolean("Config.experimental.variable_replacement");
        this.itemMetaVariableEnabled = config.getBoolean("Config.item_meta_variable_enabled");
        this.toConditionGroups = new ArrayList();
        String path = "Config.to_condition_groups";
        if (config.contains(path)) {
            for (String key : config.getConfigurationSection(path).getKeys(false)) {
                ToConditionGroup group = new ToConditionGroup(key, config.getStringList(path + "." + key));
                this.toConditionGroups.add(group);
            }
        }
        MessagesManager msgManager = new MessagesManager();
        msgManager.setTimeSeconds(config.getString("Messages.seconds"));
        msgManager.setTimeMinutes(config.getString("Messages.minutes"));
        msgManager.setTimeHours(config.getString("Messages.hours"));
        msgManager.setTimeDays(config.getString("Messages.days"));
        msgManager.setPrefix(config.getString("Messages.prefix"));
        msgManager.setPlaceholderAPICooldownNameError(config.getString("Messages.placeholderAPICooldownNameError"));
        msgManager.setPlaceholderAPICooldownReady(config.getString("Messages.placeholderAPICooldownReady"));
        this.plugin.setMessagesManager(msgManager);
    }

    public boolean reloadConfig() {
        if (!this.configFile.reloadConfig()) {
            return false;
        }
        this.configure();
        return true;
    }

    public FileConfiguration getConfig() {
        return this.configFile.getConfig();
    }

    public CommonConfig getConfigFile() {
        return this.configFile;
    }

    public void saveConfig() {
        this.configFile.saveConfig();
    }

    public void checkMessagesUpdate() {
        Path pathConfig = Paths.get(this.configFile.getRoute(), new String[0]);
        try {
            String text = new String(Files.readAllBytes(pathConfig));
            if (!text.contains("item_meta_variable_enabled:")) {
                this.getConfig().set("Config.item_meta_variable_enabled", (Object)false);
                this.saveConfig();
            }
            if (!text.contains("commandInterruptError:")) {
                this.getConfig().set("Messages.commandInterruptError", (Object)"&cUse &7/ce interrupt <event> (optional)<player>");
                this.getConfig().set("Messages.commandInterruptCorrect", (Object)"&aActions of event &7%event% &ainterrupted.");
                this.getConfig().set("Messages.commandInterruptCorrectPlayer", (Object)"&aActions of event &7%event% &ainterrupted for player &7%player%&a.");
                this.saveConfig();
            }
            if (!text.contains("variable_replacement:")) {
                this.getConfig().set("Config.experimental.variable_replacement", (Object)false);
                this.saveConfig();
            }
            if (!text.contains("commandItemError:")) {
                this.getConfig().set("Messages.commandItemError", (Object)"&cUse &7/ce item <save/remove> <name>");
                this.getConfig().set("Messages.savedItemDoesNotExists", (Object)"&cThat saved item doesn't exists.");
                this.getConfig().set("Messages.savedItemRemoved", (Object)"&aItem &7%name% &aremoved.");
                this.getConfig().set("Messages.mustHaveItemInHand", (Object)"&cYou must have an item on your hand.");
                this.getConfig().set("Messages.savedItemAlreadyExists", (Object)"&cA saved item with that name already exists.");
                this.getConfig().set("Messages.savedItemAdded", (Object)"&aItem &7%name% &asaved.");
                this.saveConfig();
            }
            if (!text.contains("commandCallCorrectPlayer:")) {
                this.getConfig().set("Messages.commandCallCorrectPlayer", (Object)"&aEvent &7%event% &asuccessfully executed for player &7%player%&a.");
                this.saveConfig();
            }
            if (!text.contains("playerNotOnline:")) {
                this.getConfig().set("Messages.playerNotOnline", (Object)"&cThat player is not online.");
                this.saveConfig();
            }
            if (!text.contains("debugEnabledPlayer:")) {
                this.getConfig().set("Messages.debugEnabledPlayer", (Object)"&aDebug now enabled for event &7%event% &aand player &7%player%&a!");
                this.getConfig().set("Messages.debugDisabledPlayer", (Object)"&aDebug disabled for event &7%event% &aand player &7%player%&a!");
                this.getConfig().set("Config.debug_actions", (Object)true);
                this.saveConfig();
            }
            if (!text.contains("eventDataResetForAllPlayers:")) {
                this.getConfig().set("Messages.eventDataResetForAllPlayers", (Object)"&aData reset for &eall players &aon event &e%event%&a!");
                this.getConfig().set("Messages.eventDataResetAllForAllPlayers", (Object)"&aAll player data reset.");
                this.saveConfig();
            }
            if (!text.contains("commandCallError:")) {
                this.getConfig().set("Messages.commandCallError", (Object)"&cUse &7/ce call <event> (optional)%variable1%=<value1>;%variableN%=<valueN>");
                this.getConfig().set("Messages.commandCallInvalidEvent", (Object)"&cYou can only execute a CALL event.");
                this.getConfig().set("Messages.commandCallCorrect", (Object)"&aEvent &7%event% &asuccessfully executed.");
                this.getConfig().set("Messages.commandCallFailed", (Object)"&cEvent &7%event% &ccould not be executed. Maybe a format error?");
                this.saveConfig();
            }
            if (!text.contains("register_commands:")) {
                ArrayList commands = new ArrayList();
                this.getConfig().set("Config.register_commands", commands);
                this.saveConfig();
            }
            if (!text.contains("placeholderAPICooldownReady:")) {
                this.getConfig().set("Messages.placeholderAPICooldownReady", (Object)"Ready!");
                this.getConfig().set("Messages.placeholderAPICooldownNameError", (Object)"No event with that name!");
                this.saveConfig();
            }
            if (!text.contains("eventDataResetAll:")) {
                this.getConfig().set("Messages.eventDataResetAll", (Object)"&aAll data reset for player &e%player%&a!");
                this.saveConfig();
            }
            if (!text.contains("eventDataReset:")) {
                this.getConfig().set("Messages.eventDataReset", (Object)"&aData reset for player &e%player% &aon event &e%event%&a!");
                this.saveConfig();
            }
            if (!text.contains("data_save_time:")) {
                this.getConfig().set("Config.data_save_time", (Object)5);
                this.saveConfig();
            }
            if (!text.contains("commandDebugError:")) {
                this.getConfig().set("Messages.commandDebugError", (Object)"&cUse &7/ce debug <event>");
                this.getConfig().set("Messages.debugEnabled", (Object)"&aDebug now enabled for event &7%event%&a!");
                this.getConfig().set("Messages.debugDisabled", (Object)"&aDebug disabled for event &7%event%&a!");
                this.getConfig().set("Messages.onlyPlayerCommand", (Object)"&cThis command can be only used by a player.");
                this.getConfig().set("Messages.playerDoesNotExists", (Object)"&cThat player doesn''t have any data.");
                this.saveConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isUpdateNotifications() {
        return this.updateNotifications;
    }

    public boolean isDebugActions() {
        return this.debugActions;
    }

    public ToConditionGroup getToConditionGroup(String name) {
        for (ToConditionGroup group : this.toConditionGroups) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public boolean isExperimentalVariableReplacement() {
        return this.experimentalVariableReplacement;
    }

    public boolean isItemMetaVariableEnabled() {
        return this.itemMetaVariableEnabled;
    }
}

