/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.model.internal;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.api.ConditionalEventsEvent;
import ce.ajneb97.managers.DebugManager;
import ce.ajneb97.managers.EventsManager;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.model.ToConditionGroup;
import ce.ajneb97.model.actions.ActionGroup;
import ce.ajneb97.model.actions.ActionTargeter;
import ce.ajneb97.model.actions.ActionTargeterType;
import ce.ajneb97.model.actions.ActionType;
import ce.ajneb97.model.actions.CEAction;
import ce.ajneb97.model.internal.VariablesProperties;
import ce.ajneb97.utils.ActionUtils;
import ce.ajneb97.utils.VariablesUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ExecutedEvent {
    private Player player;
    private LivingEntity target;
    private ArrayList<StoredVariable> eventVariables;
    private CEEvent event;
    private Event minecraftEvent;
    private String actionGroupName;
    private ConditionalEvents plugin;
    private boolean isPlaceholderAPI;
    private List<CEAction> actions;
    private boolean onWait;
    private int currentActionPos;

    public ExecutedEvent(Player player, ArrayList<StoredVariable> eventVariables, CEEvent event, String actionGroupName, Event minecraftEvent, LivingEntity target, ConditionalEvents plugin) {
        this.player = player;
        this.eventVariables = eventVariables;
        this.event = event;
        this.actionGroupName = actionGroupName;
        this.target = target;
        this.minecraftEvent = minecraftEvent;
        this.plugin = plugin;
        this.onWait = false;
        this.currentActionPos = 0;
    }

    private VariablesProperties generateVariableProperties() {
        Player playerTarget = null;
        if (this.target instanceof Player) {
            playerTarget = (Player)this.target;
        }
        return new VariablesProperties(this.eventVariables, this.player, playerTarget, this.isPlaceholderAPI, this.event, this.minecraftEvent);
    }

    public boolean setActionGroup(String actionGroupName) {
        ActionGroup actionGroup;
        int pos = actionGroupName.indexOf("{");
        if (pos != -1) {
            String[] sep;
            VariablesProperties variablesProperties = this.generateVariableProperties();
            String parameters = actionGroupName.substring(pos + 1, actionGroupName.length() - 1);
            for (String s : sep = parameters.split(";")) {
                String[] variableLineSep = s.split("=");
                String variableValue = VariablesUtils.replaceAllVariablesInLine(variableLineSep[1], variablesProperties, false);
                this.eventVariables.add(new StoredVariable(variableLineSep[0], variableValue));
            }
            this.actionGroupName = actionGroupName.substring(0, pos);
        }
        if ((actionGroup = this.event.getActionGroup(this.actionGroupName)) == null) {
            return false;
        }
        this.actions = new ArrayList<CEAction>(actionGroup.getActions());
        return true;
    }

    public void executeActions() {
        this.isPlaceholderAPI = this.plugin.getDependencyManager().isPlaceholderAPI();
        if (!this.setActionGroup(this.actionGroupName)) {
            return;
        }
        final ConditionalEventsEvent ceEvent = new ConditionalEventsEvent(this.player, this.event.getName(), this.actionGroupName);
        this.executeCancelActions();
        if (!Bukkit.isPrimaryThread()) {
            new BukkitRunnable(){

                public void run() {
                    ExecutedEvent.this.plugin.getServer().getPluginManager().callEvent((Event)ceEvent);
                    ExecutedEvent.this.executeActionsFinal();
                }
            }.runTask((Plugin)this.plugin);
        } else {
            this.plugin.getServer().getPluginManager().callEvent((Event)ceEvent);
            this.executeActionsFinal();
        }
    }

    public void executeCancelActions() {
        for (CEAction ceAction : this.actions) {
            if (ceAction.getType().equals((Object)ActionType.CANCEL_EVENT)) {
                ActionUtils.cancelEvent(ceAction.getActionLine(), this.minecraftEvent);
                return;
            }
            if (!ceAction.getType().equals((Object)ActionType.PREVENT_JOIN)) continue;
            String actionLine = ceAction.getActionLine();
            VariablesProperties variablesProperties = this.generateVariableProperties();
            actionLine = VariablesUtils.replaceAllVariablesInLine(actionLine, variablesProperties, false);
            ActionUtils.preventJoin(actionLine, this.minecraftEvent);
            return;
        }
    }

    public void continueWithActions() {
        this.onWait = false;
        this.executeActionsFinal();
    }

    private void executeActionsFinal() {
        DebugManager debugManager = this.plugin.getDebugManager();
        boolean isDebugActions = this.plugin.getConfigsManager().getMainConfigManager().isDebugActions();
        VariablesProperties variablesProperties = this.generateVariableProperties();
        for (int i = this.currentActionPos; i < this.actions.size(); ++i) {
            CEAction action = this.actions.get(i);
            ActionType actionType = action.getType();
            String apiType = action.getApiType();
            String actionLine = action.getActionLine();
            ActionTargeter targeter = action.getTargeter();
            ActionTargeterType targeterType = targeter.getType();
            String parametersLine = targeter.getParameter();
            if (parametersLine != null) {
                parametersLine = VariablesUtils.replaceAllVariablesInLine(parametersLine, variablesProperties, false);
            }
            if (targeterType.equals((Object)ActionTargeterType.TO_ALL)) {
                for (Player globalPlayer : Bukkit.getOnlinePlayers()) {
                    this.executeActionsFromToTarget(variablesProperties, (LivingEntity)globalPlayer, actionLine, actionType, apiType, isDebugActions, targeter, debugManager);
                }
            } else if (targeterType.equals((Object)ActionTargeterType.TO_TARGET)) {
                this.executeActionsFromToTarget(variablesProperties, this.target, actionLine, actionType, apiType, isDebugActions, targeter, debugManager);
            } else if (targeterType.equals((Object)ActionTargeterType.TO_WORLD)) {
                String world = parametersLine;
                for (Player globalPlayer : Bukkit.getOnlinePlayers()) {
                    if (!globalPlayer.getWorld().getName().equals(world)) continue;
                    this.executeActionsFromToTarget(variablesProperties, (LivingEntity)globalPlayer, actionLine, actionType, apiType, isDebugActions, targeter, debugManager);
                }
            } else if (targeterType.equals((Object)ActionTargeterType.TO_PLAYER)) {
                String playerName = parametersLine;
                Player onlinePlayer = Bukkit.getPlayer((String)playerName);
                if (onlinePlayer != null) {
                    this.executeActionsFromToTarget(variablesProperties, (LivingEntity)onlinePlayer, actionLine, actionType, apiType, isDebugActions, targeter, debugManager);
                }
            } else if (targeterType.equals((Object)ActionTargeterType.TO_RANGE)) {
                String[] sep = parametersLine.split(";");
                double range = Double.valueOf(sep[0]);
                boolean includePlayer = Boolean.valueOf(sep[1]);
                ArrayList<Player> globalPlayers = new ArrayList<Player>();
                if (includePlayer) {
                    globalPlayers.add(this.player);
                }
                for (Entity e : this.player.getWorld().getNearbyEntities(this.player.getLocation(), range, range, range)) {
                    Player p;
                    if (!(e instanceof Player) || (p = (Player)e).getName().equals(this.player.getName())) continue;
                    globalPlayers.add(p);
                }
                for (Player globalPlayer : globalPlayers) {
                    this.executeActionsFromToTarget(variablesProperties, (LivingEntity)globalPlayer, actionLine, actionType, apiType, isDebugActions, targeter, debugManager);
                }
            } else if (targeterType.equals((Object)ActionTargeterType.TO_CONDITION)) {
                String toConditionGroup = parametersLine;
                ToConditionGroup group = this.plugin.getConfigsManager().getMainConfigManager().getToConditionGroup(toConditionGroup);
                if (group == null) continue;
                EventsManager eventsManager = this.plugin.getEventsManager();
                ArrayList<Player> players = new ArrayList<Player>();
                for (Player globalPlayer : Bukkit.getOnlinePlayers()) {
                    variablesProperties.setToTarget(this.player);
                    boolean accomplishesConditions = eventsManager.checkToConditionAction(group.getConditions(), globalPlayer, this.isPlaceholderAPI, this.event, this.minecraftEvent);
                    if (!accomplishesConditions) continue;
                    players.add(globalPlayer);
                }
                for (Player globalPlayer : players) {
                    this.executeActionsFromToTarget(variablesProperties, (LivingEntity)globalPlayer, actionLine, actionType, apiType, isDebugActions, targeter, debugManager);
                }
            } else {
                actionLine = VariablesUtils.replaceAllVariablesInLine(actionLine, variablesProperties, false);
                if (isDebugActions) {
                    debugManager.sendActionMessage(this.event.getName(), actionLine, (LivingEntity)this.player, actionType, targeter);
                }
                this.executeAction((LivingEntity)this.player, actionType, apiType, actionLine);
            }
            if (!this.onWait) continue;
            this.currentActionPos = i + 1;
            return;
        }
    }

    private void executeActionsFromToTarget(VariablesProperties variablesProperties, LivingEntity livingEntity, String actionLine, ActionType actionType, String apiType, boolean isDebugActions, ActionTargeter targeter, DebugManager debugManager) {
        if (livingEntity instanceof Player) {
            variablesProperties.setToTarget((Player)livingEntity);
        }
        String toActionLine = VariablesUtils.replaceAllVariablesInLine(actionLine, variablesProperties, false);
        if (isDebugActions) {
            debugManager.sendActionMessage(this.event.getName(), toActionLine, livingEntity, actionType, targeter);
        }
        this.executeAction(livingEntity, actionType, apiType, toActionLine);
    }

    private void executeAction(LivingEntity livingEntity, ActionType type, String apiType, String actionLine) {
        switch (type) {
            case CONSOLE_MESSAGE: {
                ActionUtils.consoleMessage(actionLine);
                return;
            }
            case CONSOLE_COMMAND: {
                ActionUtils.consoleCommand(actionLine);
                return;
            }
            case WAIT: {
                ActionUtils.wait(actionLine, this);
                return;
            }
            case WAIT_TICKS: {
                ActionUtils.waitTicks(actionLine, this);
                return;
            }
            case KEEP_ITEMS: {
                ActionUtils.keepItems(actionLine, this.minecraftEvent);
                return;
            }
            case CANCEL_DROP: {
                ActionUtils.cancelDrop(actionLine, this.minecraftEvent);
                return;
            }
            case SET_DAMAGE: {
                ActionUtils.setDamage(actionLine, this.minecraftEvent);
                return;
            }
            case HIDE_JOIN_MESSAGE: {
                ActionUtils.hideJoinMessage(actionLine, this.minecraftEvent);
                return;
            }
            case HIDE_LEAVE_MESSAGE: {
                ActionUtils.hideLeaveMessage(actionLine, this.minecraftEvent);
                return;
            }
            case SET_DEATH_MESSAGE: {
                ActionUtils.setDeathMessage(actionLine, this.minecraftEvent);
                return;
            }
            case SET_EVENT_XP: {
                ActionUtils.setEventXp(actionLine, this.minecraftEvent);
                return;
            }
            case DISCORDSRV_EMBED: {
                ActionUtils.discordSRVEmbed(actionLine, this.plugin);
                return;
            }
            case DROP_ITEM: {
                ActionUtils.dropItem(actionLine);
                return;
            }
            case SET_BLOCK: {
                ActionUtils.setBlock(actionLine);
                return;
            }
            case SET_ITEM: {
                ActionUtils.setItem(actionLine, this.minecraftEvent);
                return;
            }
            case SUMMON: {
                ActionUtils.summon(actionLine);
                return;
            }
            case LIGHTNING_STRIKE: {
                ActionUtils.lightningStrike(actionLine);
                return;
            }
            case FIREWORK: {
                ActionUtils.firework(livingEntity, actionLine, this.plugin);
                return;
            }
            case PARTICLE: {
                ActionUtils.particle(livingEntity, actionLine);
                return;
            }
            case PLAYSOUND: {
                ActionUtils.playSound(livingEntity, actionLine);
                return;
            }
            case PLAYSOUND_RESOURCE_PACK: {
                ActionUtils.playSoundResourcePack(livingEntity, actionLine);
                return;
            }
            case CALL_EVENT: {
                ActionUtils.callEvent(actionLine, livingEntity, this.plugin, this.eventVariables);
                return;
            }
            case EXECUTE_ACTION_GROUP: {
                ActionUtils.executeActionGroup(actionLine, this, this.plugin);
                return;
            }
            case API: {
                this.plugin.getApiManager().executeAction(apiType, livingEntity, actionLine, this.minecraftEvent);
                return;
            }
        }
        if (livingEntity == null) {
            return;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            switch (type) {
                case MESSAGE: {
                    ActionUtils.message(player, actionLine);
                    return;
                }
                case CENTERED_MESSAGE: {
                    ActionUtils.centeredMessage(player, actionLine);
                    return;
                }
                case JSON_MESSAGE: {
                    ActionUtils.jsonMessage(player, actionLine);
                    return;
                }
                case MINI_MESSAGE: {
                    ActionUtils.miniMessage(player, actionLine, this.plugin);
                    return;
                }
                case PLAYER_COMMAND: {
                    ActionUtils.playerCommand(player, actionLine);
                    return;
                }
                case PLAYER_COMMAND_AS_OP: {
                    ActionUtils.playerCommandAsOp(player, actionLine);
                    return;
                }
                case PLAYER_SEND_CHAT: {
                    ActionUtils.playerSendChat(player, actionLine);
                    return;
                }
                case SEND_TO_SERVER: {
                    ActionUtils.sendToServer(player, actionLine, this.plugin);
                    return;
                }
                case GIVE_ITEM: {
                    ActionUtils.giveItem(player, actionLine);
                    return;
                }
                case REMOVE_ITEM: {
                    ActionUtils.removeItem(player, actionLine);
                    return;
                }
                case REMOVE_ITEM_SLOT: {
                    ActionUtils.removeItemSlot(player, actionLine);
                    return;
                }
                case KICK: {
                    ActionUtils.kick(player, actionLine);
                    return;
                }
                case ACTIONBAR: {
                    ActionUtils.actionbar(player, actionLine, this.plugin);
                    return;
                }
                case TITLE: {
                    ActionUtils.title(player, actionLine);
                    return;
                }
                case GAMEMODE: {
                    ActionUtils.gamemode(player, actionLine);
                    return;
                }
                case CLOSE_INVENTORY: {
                    ActionUtils.closeInventory(player);
                    return;
                }
                case CLEAR_INVENTORY: {
                    ActionUtils.clearInventory(player);
                    return;
                }
                case SET_FOOD_LEVEL: {
                    ActionUtils.setFoodLevel(player, actionLine);
                    return;
                }
                case STOPSOUND: {
                    ActionUtils.stopSound(player, actionLine);
                    return;
                }
                case STOPSOUND_RESOURCE_PACK: {
                    ActionUtils.stopSoundResourcePack(player, actionLine);
                    return;
                }
                case TAB_COMPLETE: {
                    ActionUtils.tabComplete(actionLine, this.minecraftEvent);
                }
            }
        }
        switch (type) {
            case TELEPORT: {
                ActionUtils.teleport(livingEntity, actionLine, this.minecraftEvent);
                return;
            }
            case GIVE_POTION_EFFECT: {
                ActionUtils.givePotionEffect(livingEntity, actionLine);
                return;
            }
            case REMOVE_POTION_EFFECT: {
                ActionUtils.removePotionEffect(livingEntity, actionLine);
                return;
            }
            case DAMAGE: {
                ActionUtils.damage(livingEntity, actionLine);
                return;
            }
            case SET_ON_FIRE: {
                ActionUtils.setOnFire(livingEntity, actionLine);
                return;
            }
            case FREEZE: {
                ActionUtils.freeze(livingEntity, actionLine);
                return;
            }
            case HEAL: {
                ActionUtils.heal(livingEntity, actionLine);
                return;
            }
        }
    }

    public void setOnWait(boolean onWait) {
        this.onWait = onWait;
    }

    public ConditionalEvents getPlugin() {
        return this.plugin;
    }

    public Player getPlayer() {
        return this.player;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public ArrayList<StoredVariable> getEventVariables() {
        return this.eventVariables;
    }

    public CEEvent getEvent() {
        return this.event;
    }

    public Event getMinecraftEvent() {
        return this.minecraftEvent;
    }

    public List<CEAction> getActions() {
        return this.actions;
    }
}

