/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.utils;

import ce.ajneb97.api.ConditionalEventsAPI;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.model.internal.PostEventVariableResult;
import ce.ajneb97.model.internal.VariablesProperties;
import ce.ajneb97.utils.GlobalVariablesUtils;
import ce.ajneb97.utils.VariablesUtilsExperimental;
import java.util.ArrayList;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class VariablesUtils {
    public static String replaceAllVariablesInLine(String textLine, VariablesProperties variablesProperties, boolean smallVariables) {
        boolean experimentalVariableReplacement = ConditionalEventsAPI.getPlugin().getConfigsManager().getMainConfigManager().isExperimentalVariableReplacement();
        if (experimentalVariableReplacement) {
            return VariablesUtilsExperimental.replaceAllVariablesInLine(textLine, variablesProperties);
        }
        String auxTextLine = textLine;
        char startChar = '%';
        char endChar = '%';
        if (smallVariables) {
            startChar = '{';
            endChar = '}';
        }
        int currentSmallVariableCount = 0;
        boolean isParseOther = false;
        if (textLine.startsWith("%parseother_")) {
            isParseOther = true;
        }
        for (int c = 0; c < textLine.length(); ++c) {
            int lastPos;
            if (textLine.charAt(c) != startChar || c + 1 >= textLine.length() || (lastPos = textLine.indexOf(endChar, c + 1)) == -1 || textLine.charAt(c + 1) == ' ' || textLine.charAt(lastPos - 1) == ' ') continue;
            String bigVariable = textLine.substring(c, lastPos + 1);
            String auxBigVariable = null;
            auxBigVariable = !smallVariables ? VariablesUtils.replaceAllVariablesInLine(bigVariable, variablesProperties, true) : bigVariable;
            if (smallVariables && isParseOther && currentSmallVariableCount == 1) continue;
            String auxBigVariableWithoutChars = auxBigVariable.replace(startChar + "", "").replace(endChar + "", "");
            String replaceVariableResult = VariablesUtils.replaceVariable(auxBigVariableWithoutChars, variablesProperties, smallVariables);
            if (replaceVariableResult.equals(auxBigVariableWithoutChars)) {
                auxTextLine = auxTextLine.replace(bigVariable, startChar + replaceVariableResult + endChar);
            } else {
                int firstIndex;
                if (isParseOther && smallVariables && currentSmallVariableCount == 0 && !replaceVariableResult.startsWith(startChar + "")) {
                    replaceVariableResult = startChar + replaceVariableResult + endChar;
                }
                if ((firstIndex = auxTextLine.indexOf(bigVariable)) != -1) {
                    auxTextLine = auxTextLine.substring(0, firstIndex) + replaceVariableResult + auxTextLine.substring(firstIndex + bigVariable.length());
                }
            }
            c = lastPos;
            ++currentSmallVariableCount;
        }
        return auxTextLine;
    }

    private static PostEventVariableResult replaceEventVariablesPost(String variable, VariablesProperties variablesProperties) {
        EventType eventType = variablesProperties.getEvent().getEventType();
        if (eventType.equals((Object)EventType.PLAYER_COMMAND) || eventType.equals((Object)EventType.CONSOLE_COMMAND)) {
            return VariablesUtils.replaceCommandEventsVariables(variable, variablesProperties);
        }
        if (eventType.name().startsWith("BLOCK_")) {
            return VariablesUtils.replaceBlockEventsVariables(variable, variablesProperties, eventType);
        }
        return PostEventVariableResult.noReplaced();
    }

    private static PostEventVariableResult replaceCommandEventsVariables(String variable, VariablesProperties variablesProperties) {
        if (variable.startsWith("args_substring_")) {
            String variableLR = variable.replace("args_substring_", "");
            String[] variableLRSplit = variableLR.split("-");
            String param1 = variableLRSplit[0];
            String param2 = variableLRSplit[1];
            String finalSubstring = "";
            boolean started = false;
            for (StoredVariable storedVariable : variablesProperties.getEventVariables()) {
                String name = storedVariable.getName();
                String value = storedVariable.getValue();
                if (name.equals("%arg_" + param1 + "%")) {
                    started = true;
                }
                if (!started) continue;
                if (name.equals("%arg_" + param2 + "%")) {
                    finalSubstring = finalSubstring + value;
                    started = false;
                    continue;
                }
                finalSubstring = finalSubstring + value + " ";
            }
            return PostEventVariableResult.replaced(finalSubstring);
        }
        return PostEventVariableResult.noReplaced();
    }

    private static PostEventVariableResult replaceBlockEventsVariables(String variable, VariablesProperties variablesProperties, EventType eventType) {
        Event minecraftEvent = variablesProperties.getMinecraftEvent();
        if (minecraftEvent == null) {
            return PostEventVariableResult.noReplaced();
        }
        Block block = null;
        block = eventType.equals((Object)EventType.BLOCK_INTERACT) ? ((PlayerInteractEvent)minecraftEvent).getClickedBlock() : ((BlockEvent)minecraftEvent).getBlock();
        if (block != null) {
            if (variable.startsWith("block_below_")) {
                int distance = Integer.parseInt(variable.replace("block_below_", ""));
                Location l = block.getLocation().clone().add(0.0, (double)(-distance), 0.0);
                return PostEventVariableResult.replaced(GlobalVariablesUtils.getBlockTypeInLocation(l));
            }
            if (variable.startsWith("block_above_")) {
                int distance = Integer.parseInt(variable.replace("block_above_", ""));
                Location l = block.getLocation().clone().add(0.0, (double)distance, 0.0);
                return PostEventVariableResult.replaced(GlobalVariablesUtils.getBlockTypeInLocation(l));
            }
        }
        return PostEventVariableResult.noReplaced();
    }

    private static String replaceVariable(String variable, VariablesProperties variablesProperties, boolean smallVariable) {
        Player finalPlayer = variablesProperties.getPlayer();
        Player target = variablesProperties.getTarget();
        Player to = variablesProperties.getToTarget();
        if (variable.startsWith("target:") && target != null) {
            finalPlayer = target;
            variable = variable.replace("target:", "");
        } else if (variable.startsWith("to:") && to != null) {
            finalPlayer = to;
            variable = variable.replace("to:", "");
        }
        ArrayList<StoredVariable> eventVariables = variablesProperties.getEventVariables();
        for (StoredVariable storedVariable : eventVariables) {
            if (storedVariable.getValue() == null || !variable.equals(storedVariable.getName().replace("%", ""))) continue;
            return storedVariable.getValue();
        }
        if (variable.equals("player")) {
            return GlobalVariablesUtils.variablePlayer(finalPlayer);
        }
        if (variable.startsWith("playerblock_below_")) {
            return GlobalVariablesUtils.variablePlayerBlockBelow(finalPlayer, variable);
        }
        if (variable.startsWith("playerblock_above_")) {
            return GlobalVariablesUtils.variablePlayerBlockAbove(finalPlayer, variable);
        }
        if (variable.equals("playerblock_inside")) {
            return GlobalVariablesUtils.variablePlayerBlockInside(finalPlayer);
        }
        if (variable.equals("player_is_outside")) {
            return GlobalVariablesUtils.variablePlayerIsOutside(finalPlayer);
        }
        if (variable.equals("random_player")) {
            return GlobalVariablesUtils.variableRandomPlayer();
        }
        if (variable.startsWith("random_player_")) {
            return GlobalVariablesUtils.variableRandomPlayerWorld(variable);
        }
        if (variable.equals("random_last")) {
            return GlobalVariablesUtils.variableLastRandomMinMax();
        }
        if (variable.startsWith("random_")) {
            return GlobalVariablesUtils.variableRandomMinMax(variable);
        }
        if (variable.startsWith("randomword_")) {
            return GlobalVariablesUtils.variableRandomWorld(variable);
        }
        if (variable.startsWith("playerarmor_name_")) {
            return GlobalVariablesUtils.variablePlayerArmorName(finalPlayer, variable);
        }
        if (variable.startsWith("playerarmor_")) {
            return GlobalVariablesUtils.variablePlayerArmorType(finalPlayer, variable);
        }
        if (variable.startsWith("block_at_")) {
            return GlobalVariablesUtils.variableBlockAt(variable);
        }
        if (variable.startsWith("block_data_at_")) {
            return GlobalVariablesUtils.variableBlockDataAt(variable);
        }
        if (variable.startsWith("is_nearby_")) {
            return GlobalVariablesUtils.variableIsNearby(finalPlayer, variable);
        }
        if (variable.startsWith("world_time_")) {
            return GlobalVariablesUtils.variableWorldTime(variable);
        }
        if (variable.equals("world_is_raining")) {
            return GlobalVariablesUtils.variableWorldIsRaining(finalPlayer);
        }
        if (variable.equals("player_attack_cooldown")) {
            return GlobalVariablesUtils.variablePlayerAttackCooldown(finalPlayer);
        }
        if (variable.startsWith("is_number_")) {
            return GlobalVariablesUtils.isNumber(variable);
        }
        if (variable.equals("empty")) {
            return "";
        }
        PostEventVariableResult result = VariablesUtils.replaceEventVariablesPost(variable, variablesProperties);
        if (result.isReplaced()) {
            return result.getVariable();
        }
        if (variablesProperties.isPlaceholderAPI()) {
            String variableBefore = variable;
            variable = PlaceholderAPI.setPlaceholders((Player)finalPlayer, (String)("%" + variable + "%"));
            if (("%" + variableBefore + "%").equals(variable)) {
                variable = smallVariable ? "{" + variableBefore + "}" : "%" + variableBefore + "%";
            }
        }
        return variable;
    }
}

